<?php

namespace App\Controllers;
use App\Models\GuruModel;
class GuruController extends BaseController
{
    public function index()
    {
        $model = new GuruModel();
        $data['guru'] = $model->findAll(); // Mengambil semua data guru
        return view('dashboard/guru/index',$data); // Pastikan view 'guru/index' ada
    }

    public function tambah()
    {
        return view('dashboard/guru/create'); // Menampilkan form tambah guru
    }
    
    public function detail($id_guru)
    {
        $guruModel = new \App\Models\GuruModel();
        $kelasModel = new \App\Models\KelasModel();
    
        // Ambil data guru berdasarkan ID
        $data['guru'] = $guruModel->find($id_guru);
    
        // Ambil data kelas yang diampu oleh guru (nama kelas adalah nama murid)
        $data['murid'] = $kelasModel->where('id_guru', $id_guru)->findAll();
    
        return view('dashboard/guru/detail', $data);
    }
    
    public function simpan()
    {
        $model = new GuruModel();

        // Mengambil data dari form
        $data = [
            'nama_guru' => $this->request->getPost('nama_guru'),
            'tanggal_ulang_tahun' => $this->request->getPost('tanggal_ulang_tahun'),
            'instagram' => $this->request->getPost('instagram'),
        ];

        // Menyimpan data ke database
        $model->insert($data);
        
        // Redirect ke halaman data guru
        return redirect()->to('data-guru')->with('success', 'Data guru berhasil ditambahkan.');
    }
    public function edit($id)
    {
        $model = new GuruModel();
        $data['guru'] = $model->find($id); // Mengambil data guru berdasarkan ID
        return view('dashboard/guru/edit', $data); // Menampilkan view edit
    }

    public function update($id)
    {
        $model = new GuruModel();

        // Mengambil data dari form
        $data = [
            'nama_guru' => $this->request->getPost('nama_guru'),
            'tanggal_ulang_tahun' => $this->request->getPost('tanggal_ulang_tahun'),
            'instagram' => $this->request->getPost('instagram'),
        ];

        // Memperbarui data di database
        $model->update($id, $data);
        
        // Redirect ke halaman data guru
        return redirect()->to('data-guru')->with('success', 'Data guru berhasil diperbarui.');
    }

    public function hapus($id)
    {
        $model = new GuruModel();
        $model->delete($id); // Menghapus data guru berdasarkan ID

        // Redirect ke halaman data guru dengan pesan sukses
        return redirect()->to('data-guru')->with('success', 'Data guru berhasil dihapus.');
    }
}
