<?php

namespace App\Models;

use CodeIgniter\Model;

class KelasModel extends Model
{
    protected $table = 'kelas'; // Nama tabel di database
    protected $primaryKey = 'id_kelas'; // Primary key tabel
    protected $allowedFields = ['id_guru', 'nama_kelas', 'keterangan'];

    // Menambahkan metode untuk mengambil data kelas beserta nama guru
    public function getKelasWithGuru()
    {
        $builder = $this->db->table('kelas');
        $builder->join('guru', 'guru.id_guru = kelas.id_guru'); // Menghubungkan tabel kelas dan guru
        $query = $builder->get(); // Mendapatkan hasil query
        return $query->getResultArray(); // Mengembalikan hasil sebagai array
    }
}
