<?php

namespace App\Models;

use CodeIgniter\Model;

class PembayaranGajiModel extends Model
{
    protected $table = 'pembayaran_gaji'; // Nama tabel
    protected $primaryKey = 'id_pembayaran_gaji'; // Primary key
    protected $allowedFields = ['id_guru', 'jumlah_gaji', 'tanggal_gajian', 'keterangan']; // Kolom yang diizinkan

    /**
     * Mengambil semua pembayaran gaji beserta informasi guru.
     *
     * @return array
     */
    public function getPembayaranGajiWithGuru()
    {
        return $this->select('pembayaran_gaji.*, guru.nama_guru') // Memilih kolom dari tabel pembayaran gaji dan nama guru
                    ->join('guru', 'guru.id_guru = pembayaran_gaji.id_guru') // Melakukan join dengan tabel guru
                    ->findAll(); // Mengambil semua hasil
    }

    public function searchPembayaranGaji($nama_guru = null, $tanggal_mulai = null, $tanggal_selesai = null)
    {
        $this->select('pembayaran_gaji.*, guru.nama_guru')
             ->join('guru', 'guru.id_guru = pembayaran_gaji.id_guru');
    
        if ($nama_guru) {
            $this->like('guru.nama_guru', $nama_guru);
        }
    
        if ($tanggal_mulai) {
            $this->where('tanggal_gajian >=', $tanggal_mulai);
        }
    
        if ($tanggal_selesai) {
            $this->where('tanggal_gajian <=', $tanggal_selesai);
        }
    
        return $this->findAll();
    }
    
    public function getPembayaranGajiWithGuruu($start_date, $end_date)
{
    return $this->db->table('pembayaran_gaji')
                    ->select('guru.nama_guru, pembayaran_gaji.*')
                    ->join('guru', 'guru.id_guru = pembayaran_gaji.id_guru')
                    ->where("tanggal_gajian >=", $start_date)
                    ->where("tanggal_gajian <=", $end_date)
                    ->get()
                    ->getResultArray();
}

}
