<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">

    <style>
        .table-bordered th,
        .table-bordered td {
            border: 2px solid #000; /* Border lebih tebal */
            text-align: center; /* Semua teks di posisi tengah */
            vertical-align: middle; /* Teks di tengah secara vertikal */
        }
    </style>
       <?php
    // Define function for color assignment based on keywords in the activity text
    function getBackgroundColor($activity) {
        if (strpos($activity, 'FREE') !== false) {
            return '#ffcccc'; // Merah
        } elseif (strpos($activity, 'CALISTUNG') !== false) {
            return '#cce5ff'; // Biru
        } elseif (strpos($activity, 'SD') !== false) {
            return '#d4edda'; // Hijau
        } elseif (strpos($activity, 'PRIVAT') !== false) {
            return '#fff3cd'; // Kuning
        } else {
            return 'transparent'; // Default warna latar
        }
    }
    ?>
</head>

<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- Bagian Super Admin -->
        <?php if (session()->get('role') === 'super admin') : ?>
            <?= view('layouts/sidebarsuperadmin') ?>

            <!-- Content Wrapper -->
            <div class="content-wrapper">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6">
                                <h1 class="m-0">Dashboard</h1>
                            </div>
                        </div>
                    </div>
                </div>

                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                <h2 class="mb-4">Jadwal Kelas 1 LT1</h2>

                                <!-- Tombol untuk menambah jadwal baru -->
                                <a href="<?= base_url('jadwal/create') ?>" class="btn btn-primary mb-3">Tambah Jadwal</a>
                                <a href="<?= base_url('jadwal/edit_all') ?>" class="btn btn-warning mb-3">Edit Semua Jadwal Kelas 1 LT1</a>

                                <!-- Tabel Jadwal Kelas 1 -->
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>Jam</th>
                                                <th>Senin</th>
                                                <th>Selasa</th>
                                                <th>Rabu</th>
                                                <th>Kamis</th>
                                                <th>Jumat</th>
                                                <th>Sabtu</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($jadwal)) : ?>
                                                <?php foreach ($jadwal as $row) : ?>
                                                    <tr>
                                                        <td><?= date('H:i', strtotime($row['jam_mulai'])) ?> - <?= date('H:i', strtotime($row['jam_selesai'])) ?></td>
                                                        <td style="background-color: <?= getBackgroundColor($row['senin']) ?>;">
                                                            <?= esc($row['senin']) ?> <br> (<?= esc($row['keterangan1']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['selasa']) ?>;">
                                                            <?= esc($row['selasa']) ?> <br> (<?= esc($row['keterangan2']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['rabu']) ?>;">
                                                            <?= esc($row['rabu']) ?> <br> (<?= esc($row['keterangan3']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['kamis']) ?>;">
                                                            <?= esc($row['kamis']) ?> <br> (<?= esc($row['keterangan4']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['jumat']) ?>;">
                                                            <?= esc($row['jumat']) ?> <br> (<?= esc($row['keterangan5']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['sabtu']) ?>;">
                                                            <?= esc($row['sabtu']) ?> <br> (<?= esc($row['keterangan6']) ?>)
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else : ?>
                                                <tr>
                                                    <td colspan="7" class="text-center">Tidak ada jadwal tersedia.</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- batas -->
                                <h2 class="mb-4">Jadwal Kelas 2 LT1</h2>

                                <!-- Tombol untuk menambah jadwal baru -->
                                <a href="<?= base_url('jadwal/createe') ?>" class="btn btn-primary mb-3">Tambah Jadwal</a>
                                <a href="<?= base_url('jadwal/edit_alll') ?>" class="btn btn-warning mb-3">Edit Semua Jadwal Kelas 2 LT1</a>

                                <!-- Tabel Jadwal Kelas 2 -->
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>Jam</th>
                                                <th>Senin</th>
                                                <th>Selasa</th>
                                                <th>Rabu</th>
                                                <th>Kamis</th>
                                                <th>Jumat</th>
                                                <th>Sabtu</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($kelas2)) : ?>
                                                <?php foreach ($kelas2 as $row) : ?>
                                                    <tr>
                                                        <td><?= date('H:i', strtotime($row['jam_mulai'])) ?> - <?= date('H:i', strtotime($row['jam_selesai'])) ?></td>
                                                        <td style="background-color: <?= getBackgroundColor($row['senin']) ?>;">
                                                            <?= esc($row['senin']) ?> <br> (<?= esc($row['keterangan1']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['selasa']) ?>;">
                                                            <?= esc($row['selasa']) ?> <br> (<?= esc($row['keterangan2']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['rabu']) ?>;">
                                                            <?= esc($row['rabu']) ?> <br> (<?= esc($row['keterangan3']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['kamis']) ?>;">
                                                            <?= esc($row['kamis']) ?> <br> (<?= esc($row['keterangan4']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['jumat']) ?>;">
                                                            <?= esc($row['jumat']) ?> <br> (<?= esc($row['keterangan5']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['sabtu']) ?>;">
                                                            <?= esc($row['sabtu']) ?> <br> (<?= esc($row['keterangan6']) ?>)
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else : ?>
                                                <tr>
                                                    <td colspan="7" class="text-center">Tidak ada jadwal tersedia.</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- batas -->
                                <h2 class="mb-4">Jadwal Kelas 3 LT2</h2>

                                <!-- Tombol untuk menambah jadwal baru -->
                                <a href="<?= base_url('jadwal/createee') ?>" class="btn btn-primary mb-3">Tambah Jadwal</a>
                                <a href="<?= base_url('jadwal/edit_allll') ?>" class="btn btn-warning mb-3">Edit Semua Jadwal Kelas 3 LT2</a>

                                <!-- Tabel Jadwal Kelas 3 -->
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>Jam</th>
                                                <th>Senin</th>
                                                <th>Selasa</th>
                                                <th>Rabu</th>
                                                <th>Kamis</th>
                                                <th>Jumat</th>
                                                <th>Sabtu</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($kelas3)) : ?>
                                                <?php foreach ($kelas3 as $row) : ?>
                                                    <tr>
                                                        <td><?= date('H:i', strtotime($row['jam_mulai'])) ?> - <?= date('H:i', strtotime($row['jam_selesai'])) ?></td>
                                                        <td style="background-color: <?= getBackgroundColor($row['senin']) ?>;">
                                                            <?= esc($row['senin']) ?> <br> (<?= esc($row['keterangan1']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['selasa']) ?>;">
                                                            <?= esc($row['selasa']) ?> <br> (<?= esc($row['keterangan2']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['rabu']) ?>;">
                                                            <?= esc($row['rabu']) ?> <br> (<?= esc($row['keterangan3']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['kamis']) ?>;">
                                                            <?= esc($row['kamis']) ?> <br> (<?= esc($row['keterangan4']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['jumat']) ?>;">
                                                            <?= esc($row['jumat']) ?> <br> (<?= esc($row['keterangan5']) ?>)
                                                        </td>
                                                        <td style="background-color: <?= getBackgroundColor($row['sabtu']) ?>;">
                                                            <?= esc($row['sabtu']) ?> <br> (<?= esc($row['keterangan6']) ?>)
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else : ?>
                                                <tr>
                                                    <td colspan="7" class="text-center">Tidak ada jadwal tersedia.</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- /.content-wrapper -->
        <?php endif; ?>

      
    </div>
    <!-- ./wrapper -->

    <!-- jQuery & Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>

    <script>
        function getBackgroundColor(value) {
            if (value) {
                return '#d4edda'; // Warna hijau untuk kelas yang ada
            }
            return '#f8d7da'; // Warna merah untuk kelas yang tidak ada
        }
    </script>
</body>

</html>
