<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        .filter-form {
            border: 1px solid #ced4da; /* Border color */
            padding: 15px; /* Inner padding */
            border-radius: 5px; /* Rounded corners */
            background-color: #f8f9fa; /* Light background */
        }
    </style>
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
            <?= view('layouts/sidebarsuperadmin') ?>
            <!-- Content Wrapper -->
            <div class="content-wrapper">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6">
                            <h1>Riwayat Pembayaran SPP 
                                    <?php if (!empty($riwayat_pembayaran)): ?>
                                        <?= $riwayat_pembayaran[0]['nama_siswa'] ?>
                                    <?php endif; ?>
                                </h1>
                            </div>
                        </div>
                    </div>
                </div>
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">


                                <!-- Pesan Sementara -->
                                <?php if (session()->getFlashdata('error')): ?>
                                    <div class="alert alert-warning">
                                        <?= session()->getFlashdata('error') ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Filter Form di dalam div tersendiri -->
                                <div class="row mb-4 filter-form">
                                    <div class="col-md-4">
                                        <!-- Form untuk Filter Riwayat Pembayaran berdasarkan Tahun -->
                                        <form action="<?= base_url('pembayaran_spp/riwayat/' . $id_siswa) ?>" method="get">
                                            <div class="form-group">
                                                <label for="tahun">Tahun:</label>
                                                <input type="number" name="tahun" id="tahun" class="form-control form-control-sm" placeholder="Tahun" />
                                            </div>
                                            <button type="submit" class="btn btn-primary btn-sm">Terapkan Filter</button>
                                        </form>
                                    </div>
                                </div>
<!-- Tombol untuk membuka popup modal (Export Excel) -->
<button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#exportModal">
                                    Export Excel
                                </button>

                                <!-- Modal untuk Export Excel -->
                                <div class="modal fade" id="exportModal" tabindex="-1" role="dialog" aria-labelledby="exportModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exportModalLabel">Export Riwayat Pembayaran ke Excel</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <!-- Form dalam Modal untuk Export Excel -->
                                                <form id="exportForm" action="<?= base_url('pembayaran_spp/exportExcel/' . $id_siswa) ?>" method="post">
                                                    <div class="form-group">
                                                        <label for="tahun_export">Tahun:</label>
                                                        <input type="number" name="tahun" id="tahun_export" class="form-control" placeholder="Tahun" />
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                                                <button type="submit" class="btn btn-success" form="exportForm">Export</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tombol untuk membuka popup modal (Export PDF) -->
                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#pdfModal">
                                    Export PDF
                                </button>

                                <!-- Modal untuk Export PDF -->
                                <div class="modal fade" id="pdfModal" tabindex="-1" role="dialog" aria-labelledby="pdfModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="pdfModalLabel">Export Riwayat Pembayaran ke PDF</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <!-- Form dalam Modal untuk Export PDF -->
                                                <form id="pdfForm" action="<?= base_url('pembayaran_spp/exportPdf/' . $id_siswa) ?>" method="post">
                                                    <div class="form-group">
                                                        <label for="tahun_export_pdf">Tahun:</label>
                                                        <input type="number" name="tahun" id="tahun_export_pdf" class="form-control" placeholder="Tahun" />
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                                                <button type="submit" class="btn btn-danger" form="pdfForm">Export</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php
// Pengaturan Pagination
$items_per_page = 12; // Jumlah item yang ditampilkan per halaman
$total_items = count($riwayat_pembayaran); // Total item
$total_pages = ceil($total_items / $items_per_page); // Total halaman

// Halaman saat ini (default adalah 1)
$current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

// Pastikan halaman saat ini dalam rentang yang valid
if ($current_page < 1) $current_page = 1;
if ($current_page > $total_pages) $current_page = $total_pages;

// Hitung indeks awal untuk halaman saat ini
$start_index = ($current_page - 1) * $items_per_page;

// Batasi data yang ditampilkan untuk halaman saat ini
$limited_pembayaran = array_slice($riwayat_pembayaran, $start_index, $items_per_page);
?>

<!-- Tabel Riwayat Pembayaran -->
<div class="table-responsive">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Tahun</th>
                <th>Bulan</th>
                <th>Tanggal Pembayaran</th>
                <th>Jumlah Pembayaran</th>
                <th>Status</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($limited_pembayaran)): ?>
                <?php foreach ($limited_pembayaran as $pembayaran): ?>
                    <tr>
                        <td><?= $pembayaran['tahun'] ?></td>
                        <td><?= $pembayaran['bulan'] ?></td>
                        <td><?= $pembayaran['tanggal_pembayaran'] ?></td>
                        <td>Rp <?= number_format($pembayaran['jumlah_pembayaran'], 0, ',', '.') ?></td>
                        <td><?= $pembayaran['status'] ?></td>
                        <td><?= $pembayaran['keterangan'] ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" class="text-center">Tidak ada riwayat pembayaran untuk tahun tersebut</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php
// Ambil query string saat ini (parameter GET) kecuali 'page' untuk menjaga parameter lainnya tetap utuh
$queryString = $_SERVER['QUERY_STRING'];

// Hapus parameter 'page' yang ada dari query string
$queryString = preg_replace('/(\?|&)page=\d+/', '', $queryString);

// Tambahkan '&' jika query string ada, atau mulai dengan '?'
$queryString = ($queryString) ? '?' . $queryString . '&' : '?page=';
?>

<nav aria-label="Navigasi halaman">
    <ul class="pagination justify-content-center">
        <!-- Tombol Sebelumnya -->
        <li class="page-item <?= ($current_page == 1) ? 'disabled' : '' ?>">
            <a class="page-link" href="<?= $queryString ?>page=<?= $current_page - 1 ?>" aria-label="Sebelumnya">
                <span aria-hidden="true">&laquo;</span>
            </a>
        </li>

        <!-- Link Nomor Halaman -->
        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
            <li class="page-item <?= ($current_page == $i) ? 'active' : '' ?>">
                <a class="page-link" href="<?= $queryString ?>page=<?= $i ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>

        <!-- Tombol Selanjutnya -->
        <li class="page-item <?= ($current_page == $total_pages) ? 'disabled' : '' ?>">
            <a class="page-link" href="<?= $queryString ?>page=<?= $current_page + 1 ?>" aria-label="Selanjutnya">
                <span aria-hidden="true">&raquo;</span>
            </a>
        </li>
    </ul>
</nav>


                                

                                

                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- /.content-wrapper -->
        <?php else: ?>
            <div class="alert alert-danger">
                <h4>Anda tidak memiliki akses ke halaman ini.</h4>
            </div>
        <?php endif; ?>
    </div>
    <!-- /.wrapper -->

    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
</body>
</html>
