<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Akuntansi</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Laporan Akuntansi</h1>
        <h5>Rincian Pendapatan dan Pengeluaran</h5>
        <table>
            <thead>
                <tr>
                    <th>Sumber</th>
                    <th>Tanggal</th>
                    <th>Pendapatan (Rp)</th>
                    <th>Pengeluaran (Rp)</th>
                </tr>
            </thead>
            <tbody>
                <!-- Rincian Pendapatan -->
                <?php foreach ($rincian_biaya_pendaftaran as $item): ?>
                        <tr>
                            <td>Biaya Pendaftaran - <?= esc($item['nama']) ?></td>
                            <td><?= esc($item['tanggal_pendaftaran']) ?></td>
                            <td>Rp.<?= number_format($item['biaya_pendaftaran'], 0, ',', '.') ?></td>
                            <td></td>
                        </tr>
                        <?php endforeach; ?>
                <?php foreach ($rincian_pembayaran_spp as $item): ?>
                <tr>
                    <td>Pembayaran SPP - Bulan <?= esc($item['bulan']) ?> - Nama <?= esc($item['nama']) ?></td>
                    <td><?= esc($item['tanggal_pembayaran']) ?></td>
                    <td>Rp.<?= number_format($item['jumlah_pembayaran'], 0, ',', '.') ?></td>
                    <td></td>
                </tr>
                <?php endforeach; ?>

                <?php foreach ($rincian_penjualan_buku as $item): ?>
                <tr>
                    <td>Penjualan Buku - <?= esc($item['nama_buku']) ?></td>
                    <td><?= esc($item['tanggal_penjualan']) ?></td> 
                    <td>Rp.<?= number_format($item['total_harga'], 0, ',', '.') ?></td>
                    <td></td>
                </tr>
                <?php endforeach; ?>

                <?php foreach ($rincian_gaji as $item): ?>
                <tr>
                    <td>Gaji Guru - <?= esc($item['nama_guru']) ?></td>
                    <td><?= esc($item['tanggal_gajian']) ?></td>
                    <td></td>
                    <td>Rp.<?= number_format($item['jumlah_gaji'], 0, ',', '.') ?></td>
                </tr>
                <?php endforeach; ?>

                <?php foreach ($rincian_pengeluaran as $item): ?>
                <tr>
                    <td>Pengeluaran Barang - <?= esc($item['nama_barang']) ?></td>
                    <td><?= esc($item['tanggal_beli']) ?></td>
                    <td></td>
                    <td>Rp.<?= number_format($item['harga'], 0, ',', '.') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="2">Total</th>
                    <th>Rp.<?= number_format($total_pendapatan ?? 0, 0, ',', '.') ?></th>
                    <th>Rp.<?= number_format($total_pengeluaran_semua ?? 0, 0, ',', '.') ?></th>
                </tr>
                <tr>
                    <th colspan="2">Laba/Rugi</th>
                    <th colspan="2"><?= ($laba_rugi >= 0) ? 'Laba: ' : 'Rugi: ' ?>Rp. <?= number_format($laba_rugi ?? 0, 0, ',', '.') ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
</body>
</html>
