<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
        <?= view('layouts/sidebarsuperadmin') ?>
                <!-- Content Wrapper -->
                <div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col-sm-6">
                    <h1 class="mt-4">Edit Pembayaran SPP</h1>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card shadow-sm">
                        <div class="card-header bg-info text-white">
                            <h4 class="mb-0">Form Edit Pembayaran SPP</h4>
                        </div>
                        <div class="card-body">
                        
                        <form action="<?= base_url('pembayaran_spp/update/' . $pembayaran['id_pembayaran']) ?>" method="post">
            <div class="form-group">
                <label for="id_siswa">Siswa</label>
                <select name="id_siswa" class="form-control" required>
                    <?php foreach ($siswa as $row): ?>
                        <option value="<?= $row['id_siswa'] ?>" <?= $row['id_siswa'] == $pembayaran['id_siswa'] ? 'selected' : '' ?>>
                            <?= $row['nama'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="bulan">Bulan</label>
                <select name="bulan" class="form-control" required>
                    <option value="">Pilih Bulan</option>
                    <?php 
                    $bulanList = [
                        'Januari' => 'Januari', 'Februari' => 'Februari', 'Maret' => 'Maret', 'April' => 'April',
                        'Mei' => 'Mei', 'Juni' => 'Juni', 'Juli' => 'Juli', 'Agustus' => 'Agustus',
                        'September' => 'September', 'Oktober' => 'Oktober', 'November' => 'November', 'Desember' => 'Desember'
                    ];
                    foreach ($bulanList as $key => $value): ?>
                        <option value="<?= $key ?>" <?= $key == $pembayaran['bulan'] ? 'selected' : '' ?>>
                            <?= $value ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="tahun">Tahun</label>
                <input type="number" name="tahun" class="form-control" value="<?= $pembayaran['tahun'] ?>" required>
            </div>

            <div class="form-group">
                <label for="jumlah_pembayaran">Jumlah Pembayaran</label>
                <input type="number" name="jumlah_pembayaran" class="form-control" value="<?= $pembayaran['jumlah_pembayaran'] ?>" required>
            </div>

            <div class="form-group">
                <label for="tanggal_pembayaran">Tanggal Pembayaran</label>
                <input type="date" name="tanggal_pembayaran" class="form-control" value="<?= $pembayaran['tanggal_pembayaran'] ?>" required>
            </div>

            <div class="form-group">
                <label for="metode_pembayaran">Metode Pembayaran</label>
                <select name="metode_pembayaran" class="form-control" required>
                    <option value="tunai">Tunai</option>
                    <option value="transfer bank">Transfer Bank</option>
                    <option value="lainnya">Lainnya</option>
                </select>
            </div>

            <div class="form-group">
                <label for="status">Status</label>
                <select name="status" class="form-control" required>
                    <option value="lunas" <?= $pembayaran['status'] == 'lunas' ? 'selected' : '' ?>>Lunas</option>
                    <option value="belum lunas" <?= $pembayaran['status'] == 'belum lunas' ? 'selected' : '' ?>>Belum Lunas</option>
                </select>
            </div>

            <div class="form-group">
                <label for="keterangan">Keterangan</label>
                <textarea name="keterangan" class="form-control"><?= $pembayaran['keterangan'] ?></textarea>
            </div>

            <button type="submit" class="btn btn-primary">Update Pembayaran</button>
        </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

        <!-- /.content-wrapper -->                   
    </div>
     <?php else: ?>
     <div class="alert alert-danger">
     <h4>Anda tidak memiliki akses ke halaman ini.</h4>
     </div>
    <?php endif; ?>
    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
    <!-- jQuery -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>


</body>
</html>
