<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">
        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
            <?= view('layouts/sidebarsuperadmin') ?>
            
            <!-- Content Wrapper -->
            <div class="content-wrapper">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6">
                                <h1 class="m-0">Tambah Data Siswa</h1>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main content -->
                <section class="content">
                    <div class="container-fluid">
                        <div class="row justify-content-center">
                            <div class="col-md-8">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Tambah Data Siswa</h3>
                                    </div>
                                    <div class="card-body">
                                   

<form method="post" action="<?= base_url('siswa/store') ?>">
    <div class="form-group">
        <label for="nama">Nama:</label>
        <input type="text" name="nama" id="nama" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="tanggal_lahir">Tanggal Lahir:</label>
        <input type="date" name="tanggal_lahir" id="tanggal_lahir" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="nama_org_tua">Nama Orang Tua:</label>
        <input type="text" name="nama_org_tua" id="nama_org_tua" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="alamat">Alamat:</label>
        <input type="text" name="alamat" id="alamat" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="no_hp">No HP:</label>
        <input type="text" name="no_hp" id="no_hp" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="akun_instagram">Akun Instagram:</label>
        <input type="text" name="akun_instagram" id="akun_instagram" class="form-control">
    </div>

    <div class="form-group">
        <label for="tanggal_pendaftaran">Tanggal Pendaftaran:</label>
        <input type="date" name="tanggal_pendaftaran" id="tanggal_pendaftaran" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="biaya_pendaftaran">Biaya Pendaftaran:</label>
        <input type="number" name="biaya_pendaftaran" id="biaya_pendaftaran" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="status">Status:</label>
        <select name="status" id="status" class="form-control" required>
            <option value="aktif">Aktif</option>
            <option value="nonaktif">Nonaktif</option>
        </select>
    </div>

    <div>
        <button type="submit" class="btn btn-primary">Simpan</button>
        <a href="<?= base_url('siswa') ?>" class="btn btn-secondary">Kembali</a>
    </div>
</form>



                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- /.content -->
            </div>
            <!-- /.content-wrapper -->
        <?php else: ?>
            <div class="alert alert-danger">
                <h4>Anda tidak memiliki akses ke halaman ini.</h4>
            </div>
        <?php endif; ?>
    </div>
    <!-- /.wrapper -->

    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
</body>
</html>
