<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Route untuk halaman login
$routes->get('/', 'Auth::login'); // Halaman login
$routes->get('/auth/login', 'Auth::login'); // Halaman login dengan URL alternatif

// Route untuk proses autentikasi
$routes->post('/auth/authenticate', 'Auth::authenticate'); // Proses login

// Route untuk logout
$routes->get('/logout', 'Auth::logout'); // Proses logout

// Route untuk dashboard
$routes->get('/dashboard', 'Dashboard::index'); // Halaman dashboard
//$routes->get('/dashboard/superadmin', 'Dashboard::superadmin'); // Halaman dashboard untuk super admin
$routes->get('/dashboardpetugas/petugas', 'Dashboard::petugas'); // Halaman dashboard untuk petugas

// Route untuk halaman registrasi
$routes->get('/auth/register', 'Auth::register'); // Halaman registrasi
$routes->post('/auth/create', 'Auth::create'); // Proses registrasi pengguna

// Route untuk halaman edit profil
$routes->get('/edit-profil', 'UserController::editProfil');
$routes->post('/update-profil', 'UserController::updateProfil');

$routes->get('petugas/edit-profil', 'UserController::editpetugas');
$routes->post('petugas/update-profil', 'UserController::updatepetugas');


$routes->get('siswa', 'SiswaController::index'); // Route for displaying students
$routes->get('siswa/create', 'SiswaController::create'); // Route for creating a new student
$routes->post('siswa/store', 'SiswaController::store'); // Route for storing the new student data
$routes->get('siswa/edit/(:num)', 'SiswaController::edit/$1'); // Route for editing a student
$routes->post('siswa/update/(:num)', 'SiswaController::update/$1'); // Route for updating student data
$routes->get('siswa/delete/(:num)', 'SiswaController::delete/$1'); // Route for deleting a student
$routes->get('siswa/export_excel', 'SiswaController::exportExcel'); // Route for exporting to Excel
$routes->get('siswa/export_pdf', 'SiswaController::exportPdf'); // Route for exporting to PDF
$routes->get('Riwayat_spp', 'SiswaController::Riwayat_spp');

//jadwal detil
$routes->get('jadwal', 'JadwalController::index');
$routes->get('jadwal/create', 'JadwalController::create');
$routes->post('jadwal/store', 'JadwalController::store');
$routes->get('jadwal/edit_all', 'JadwalController::edit_all');
$routes->post('jadwal/update_all', 'JadwalController::update_all');
$routes->get('jadwal/createe', 'JadwalController::createe');
$routes->post('jadwal/storee', 'JadwalController::storee');
$routes->get('jadwal/edit_alll', 'JadwalController::edit_alll');
$routes->post('jadwal/update_alll', 'JadwalController::update_alll');
$routes->get('jadwal/createee', 'JadwalController::createee');
$routes->post('jadwal/storeee', 'JadwalController::storeee');
$routes->get('jadwal/edit_allll', 'JadwalController::edit_allll');
$routes->post('jadwal/update_allll', 'JadwalController::update_allll');
$routes->get('jadwal/hapus/(:num)', 'JadwalController::hapus/$1');
$routes->get('jadwal/hapuss/(:num)', 'JadwalController::hapuss/$1');
$routes->get('jadwal/hapusss/(:num)', 'JadwalController::hapusss/$1');



// Route untuk halaman create pembayaran_spp siswa
//$routes->get('pembayaran_spp', 'PembayaranSppController::index');
$routes->get('pembayaran_spp', 'PembayaranSppController::index'); // Untuk halaman utama tanpa parameter

$routes->get('pembayaran_spp/create', 'PembayaranSppController::create');
$routes->post('pembayaran_spp/store', 'PembayaranSppController::store');

// Route untuk halaman edits dan hapus pembayaran_spp siswa 
$routes->get('pembayaran_spp/edit/(:num)', 'PembayaranSppController::edit/$1');
$routes->post('pembayaran_spp/update/(:num)', 'PembayaranSppController::update/$1');
$routes->get('pembayaran_spp/delete/(:num)', 'PembayaranSppController::delete/$1');
$routes->match(['get', 'post'],'pembayaran_spp/search', 'PembayaranSppController::search');
//$routes->get('pembayaran_spp/riwayat/(:num)', 'PembayaranSppController::riwayat/$1');
//$routes->post('pembayaran_spp/riwayat/(:num)', 'PembayaranSppController::riwayat/$1');
$routes->match(['get', 'post'], 'pembayaran_spp/riwayat/(:num)', 'PembayaranSppController::riwayat/$1');
$routes->get('pembayaran_spp/export_excel/(:num)', 'PembayaranSppController::exportExcel/$1');
$routes->post('pembayaran_spp/exportExcel/(:num)', 'PembayaranSppController::exportExcel/$1');
$routes->post('pembayaran_spp/exportPdf/(:num)', 'PembayaranSppController::exportPdf/$1');
$routes->post('pembayaran_spp/export_excel', 'PembayaranSppController::export_excel');
$routes->post('pembayaran_spp/export_pdf', 'PembayaranSppController::export_pdf');

//guru
$routes->get('data-guru', 'GuruController::index');
$routes->get('guru/tambah', 'GuruController::tambah'); // Menampilkan form tambah guru
$routes->post('guru/simpan', 'GuruController::simpan'); // Menyimpan data guru
$routes->get('guru/edit/(:num)', 'GuruController::edit/$1'); // Menampilkan form edit guru
$routes->get('guru/hapus/(:num)', 'GuruController::hapus/$1'); // Menghapus data guru
$routes->post('guru/update/(:num)', 'GuruController::update/$1'); // Memperbarui data guru
$routes->get('/guru/detail/(:num)', 'GuruController::detail/$1');

//kelas
$routes->get('data-kelas', 'KelasController::index'); // Rute untuk menampilkan data kelas
$routes->get('kelas/tambah', 'KelasController::tambah');
$routes->post('kelas/simpan', 'KelasController::simpan');
$routes->get('kelas/edit/(:segment)', 'KelasController::edit/$1');
$routes->post('kelas/update/(:segment)', 'KelasController::update/$1');
$routes->get('kelas/hapus/(:segment)', 'KelasController::hapus/$1');

//gaji
$routes->get('pembayaran_gajii', 'PembayaranGajiController::indexx');
$routes->get('pembayaran_gaji', 'PembayaranGajiController::index'); // Menampilkan data pembayaran gaji
$routes->get('pembayaran_gaji/tambah', 'PembayaranGajiController::tambah'); // Menampilkan form tambah pembayaran gaji
$routes->post('pembayaran_gaji/store', 'PembayaranGajiController::store'); // Menyimpan data pembayaran gaji baru
$routes->get('pembayaran_gaji/edit/(:num)', 'PembayaranGajiController::edit/$1'); // Menampilkan form edit pembayaran gaji
$routes->post('pembayaran_gaji/update/(:num)', 'PembayaranGajiController::update/$1'); // Mengupdate data pembayaran gaji
$routes->get('pembayaran_gaji/hapus/(:num)', 'PembayaranGajiController::hapus/$1'); // Menghapus data pembayaran gaji
$routes->get('pembayaran_gaji/exportToExcel', 'PembayaranGajiController::exportToExcel');
$routes->get('pembayaran_gaji/exportToPDF', 'PembayaranGajiController::exportToPdf');

//pengeluaran
$routes->get('/pengeluaran', 'PengeluaranController::index'); // Menampilkan data pengeluaran
$routes->get('/pengeluaran/tambah', 'PengeluaranController::tambah'); // Menambah pengeluaran
$routes->get('/pengeluaran/edit/(:num)', 'PengeluaranController::edit/$1'); // Mengedit pengeluaran
$routes->post('pengeluaran/update/(:num)', 'PengeluaranController::update/$1');
$routes->get('/pengeluaran/hapus/(:num)', 'PengeluaranController::hapus/$1'); // Menghapus pengeluaran
// Rute untuk menyimpan data pengeluaran
$routes->post('pengeluaran/store', 'PengeluaranController::store');
$routes->get('pengeluaran/export/excel', 'PengeluaranController::exportToExcel');
$routes->get('pengeluaran/export/pdf', 'PengeluaranController::exportToPDF');

//buku 
$routes->get('/data-Buku', 'BukuController::index');            // Rute untuk halaman daftar buku
$routes->get('buku/create', 'BukuController::create');      // Rute untuk halaman tambah buku
$routes->post('buku/store', 'BukuController::store');       // Rute untuk menyimpan data buku baru
$routes->get('buku/edit/(:num)', 'BukuController::edit/$1');// Rute untuk halaman edit buku
$routes->post('buku/update/(:num)', 'BukuController::update/$1'); // Rute untuk mengupdate buku
$routes->post('buku/delete/(:num)', 'BukuController::delete/$1'); // Rute untuk menghapus buku

//penjualan buku 
$routes->get('pendapatan-buku', 'PendapatanBukuController::index');
$routes->get('pendapatan-buku/create', 'PendapatanBukuController::create');
$routes->post('pendapatan-buku/store', 'PendapatanBukuController::store');
$routes->post('pendapatan-buku/delete/(:num)', 'PendapatanBukuController::delete/$1');
$routes->get('pendapatan-buku/search', 'PendapatanBukuController::search');
// Rute untuk ekspor ke Excel
$routes->get('pendapatan-buku/exportToExcel', 'PendapatanBukuController::exportToExcel');

// Rute untuk ekspor ke PDF
$routes->get('pendapatan-buku/exportToPDF', 'PendapatanBukuController::exportToPDF');

//laporan
$routes->get('/laporan-akuntansi', 'LaporanAkuntansi::index');
$routes->get('laporan-akuntansi/export-excel', 'LaporanAkuntansi::exportExcel');
$routes->get('laporan-akuntansi/export-pdf', 'LaporanAkuntansi::exportPdf');

//data kelas siswa
$routes->get('data-kelas-murid', 'DataKelasMurid::index');
$routes->get('data-kelas-murid/create', 'DataKelasMurid::create');
$routes->post('data-kelas-murid/store', 'DataKelasMurid::store');
$routes->get('data-kelas-murid/edit/(:num)', 'DataKelasMurid::edit/$1');
$routes->post('data-kelas-murid/update/(:num)', 'DataKelasMurid::update/$1');
$routes->get('data-kelas-murid/delete/(:num)', 'DataKelasMurid::delete/$1');


// Tambahkan route lain jika diperlukan
