<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\RoleModel; // Tambahkan import RoleModel
use App\Models\UserRoleModel; // Tambahkan import UserRoleModel
use CodeIgniter\Controller;

class Auth extends Controller
{
    public function login()
    {
        return view('auth/login');
    }

    public function authenticate()
    {
        $session = session();
        $model = new UserModel();

        // Mengambil data dari POST
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        // Mencari pengguna berdasarkan username
        $user = $model->where('username', $username)->first();

        if ($user) {
            if (password_verify($password, $user['password'])) {
                // Menyimpan informasi pengguna di session
                $session->set([
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'isLoggedIn' => true,
                ]);

                // Mengambil role pengguna
                $roleModel = new RoleModel();
                $role = $roleModel->join('user_roles', 'user_roles.role_id = roles.id')
                                  ->where('user_roles.user_id', $user['id'])
                                  ->first();

                // Simpan role di session jika ada
                if ($role) {
                    $session->set('role', $role['name']);

                    // Mengalihkan ke dashboard berdasarkan role
                    if ($role['name'] === 'super admin') {
                        return redirect()->to('/dashboard');
                    } else {
                        return redirect()->to('/dashboardpetugas/petugas');
                    }
                } else {
                    // Jika tidak ada role ditemukan
                    $session->setFlashdata('msg', 'Role tidak ditemukan.');
                    return redirect()->to('/auth/login');
                }
            } else {
                $session->setFlashdata('msg', 'Password salah.');
                return redirect()->to('/auth/login');
            }
        } else {
            $session->setFlashdata('msg', 'Username tidak ditemukan.');
            return redirect()->to('/auth/login');
        }
    }

    public function logout()
    {
        $session = session();
        $session->destroy();
        return redirect()->to('/');
    }

    public function register()
    {
        return view('auth/register');
    }

    public function create()
    {
        $model = new UserModel();
        $session = session();

        // Mengambil data dari form
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');
        $email = $this->request->getPost('email');

        // Meng-hash password sebelum disimpan
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        // Menyimpan pengguna baru ke dalam database
        $data = [
            'username' => $username,
            'password' => $hashedPassword,
            'email' => $email,
        ];

        // Menambahkan pengguna baru
        if ($model->save($data)) {
            $userId = $model->insertID(); // Mendapatkan ID pengguna yang baru dibuat

            // Menetapkan role 'petugas' secara default
            $roleModel = new RoleModel();
            $role = $roleModel->where('name', 'petugas')->first();

            if (!$role) {
                // Jika role 'petugas' belum ada, buat role baru
                $roleModel->save(['name' => 'petugas']);
                $roleId = $roleModel->insertID();
            } else {
                // Jika role sudah ada, ambil ID-nya
                $roleId = $role['id'];
            }

            // Mengaitkan pengguna dengan role
            $userRoleModel = new UserRoleModel();
            $userRoleModel->save(['user_id' => $userId, 'role_id' => $roleId]);

            $session->setFlashdata('msg', 'Registrasi berhasil! Silakan login.');
            return redirect()->to('/auth/login');
        } else {
            $session->setFlashdata('msg', 'Registrasi gagal. Silakan coba lagi.');
            return redirect()->to('/auth/register');
        }
    }
}
