<?php

namespace App\Controllers;

use App\Models\SiswaModel;
use App\Models\PembayaranSPPModel;
use App\Models\PenjualanBukuModel;
use App\Models\PembayaranGajiModel;
use App\Models\PengeluaranModel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Dompdf\Dompdf;
use Dompdf\Options;

class LaporanAkuntansi extends BaseController
{
    protected $siswaModel;
    protected $pembayaranSPPModel;
    protected $penjualanBukuModel;
    protected $pembayaranGajiModel;
    protected $pengeluaranModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
        $this->pembayaranSPPModel = new PembayaranSPPModel();
        $this->penjualanBukuModel = new PenjualanBukuModel();
        $this->pembayaranGajiModel = new PembayaranGajiModel();
        $this->pengeluaranModel = new PengeluaranModel();
    }

    public function index()
{
    // Ambil input rentang tanggal dari form
    $start_date = $this->request->getGet('start_date');
    $end_date = $this->request->getGet('end_date');

    // Default rentang tanggal (jika belum dipilih)
    if (!$start_date) {
        $start_date = date('Y-m-d');  // Tanggal default awal
    }
    if (!$end_date) {
        $end_date = date('Y-m-d');  // Tanggal hari ini
    }

    // Ambil rincian pendapatan dan pengeluaran berdasarkan rentang tanggal
    $rincian_biaya_pendaftaran = $this->siswaModel->where("tanggal_pendaftaran >=", $start_date)
                                                  ->where("tanggal_pendaftaran <=", $end_date)
                                                  ->findAll();
    $rincian_pembayaran_spp = $this->siswaModel->getPembayaranSPPWithSiswa($start_date, $end_date);
    $rincian_penjualan_buku = $this->penjualanBukuModel->getPenjualanBukuWithNamaBuku($start_date, $end_date);
    $rincian_gaji = $this->pembayaranGajiModel->getPembayaranGajiWithGuruu($start_date, $end_date);
    $rincian_pengeluaran = $this->pengeluaranModel->where("tanggal_beli >=", $start_date)
                                                  ->where("tanggal_beli <=", $end_date)
                                                  ->findAll();

    // Ambil total pendapatan
    $total_biaya_pendaftaran = $this->siswaModel->selectSum('biaya_pendaftaran')
                                                ->where("tanggal_pendaftaran >=", $start_date)
                                                ->where("tanggal_pendaftaran <=", $end_date)
                                                ->first()['biaya_pendaftaran'] ?? 0; // Gunakan ?? 0 untuk mencegah error

    $total_spp = $this->pembayaranSPPModel->selectSum('jumlah_pembayaran')
                                          ->where("tanggal_pembayaran >=", $start_date)
                                          ->where("tanggal_pembayaran <=", $end_date)
                                          ->first()['jumlah_pembayaran'] ?? 0; // Gunakan ?? 0 untuk mencegah error

    $total_penjualan_buku = $this->penjualanBukuModel->selectSum('total_harga')
                                                     ->where("tanggal_penjualan >=", $start_date)
                                                     ->where("tanggal_penjualan <=", $end_date)
                                                     ->first()['total_harga'] ?? 0; // Gunakan ?? 0 untuk mencegah error

    // Ambil total pengeluaran
    $total_gaji = $this->pembayaranGajiModel->selectSum('jumlah_gaji')
                                            ->where("tanggal_gajian >=", $start_date)
                                            ->where("tanggal_gajian <=", $end_date)
                                            ->first()['jumlah_gaji'] ?? 0; // Gunakan ?? 0 untuk mencegah error

    $total_pengeluaran = $this->pengeluaranModel->selectSum('harga')
                                                ->where("tanggal_beli >=", $start_date)
                                                ->where("tanggal_beli <=", $end_date)
                                                ->first()['harga'] ?? 0; // Gunakan ?? 0 untuk mencegah error

    // Hitung laba/rugi
    $total_pendapatan = $total_biaya_pendaftaran + $total_spp + $total_penjualan_buku;
    $total_pengeluaran_semua = $total_gaji + $total_pengeluaran;
    $laba_rugi = $total_pendapatan - $total_pengeluaran_semua;

    $data = [
        'rincian_biaya_pendaftaran' => $rincian_biaya_pendaftaran,
        'rincian_pembayaran_spp' => $rincian_pembayaran_spp,
        'rincian_penjualan_buku' => $rincian_penjualan_buku,
        'rincian_gaji' => $rincian_gaji,
        'rincian_pengeluaran' => $rincian_pengeluaran,
        'total_biaya_pendaftaran' => $total_biaya_pendaftaran,
        'total_spp' => $total_spp,
        'total_penjualan_buku' => $total_penjualan_buku,
        'total_gaji' => $total_gaji,
        'total_pengeluaran' => $total_pengeluaran,
        'total_pendapatan' => $total_pendapatan,
        'total_pengeluaran_semua' => $total_pengeluaran_semua,
        'laba_rugi' => $laba_rugi,
        'start_date' => $start_date,
        'end_date' => $end_date
    ];

    return view('dashboard/laporan_akuntansi/index', $data);
}


public function exportExcel()
{
    // Ambil input rentang tanggal dari form
    $start_date = $this->request->getGet('start_date');
    $end_date = $this->request->getGet('end_date');

    // Jika tanggal tidak diberikan, gunakan tanggal default
    if (!$start_date) {
        $start_date = date('Y-m-01'); // Tanggal awal bulan ini
    }
    if (!$end_date) {
        $end_date = date('Y-m-d'); // Tanggal hari ini
    }

    // Ambil rincian pendapatan dan pengeluaran berdasarkan rentang tanggal
    $rincian_biaya_pendaftaran = $this->siswaModel->where("tanggal_pendaftaran >=", $start_date)
                                                  ->where("tanggal_pendaftaran <=", $end_date)
                                                  ->findAll();
    $rincian_pembayaran_spp = $this->siswaModel->getPembayaranSPPWithSiswa($start_date, $end_date);
    $rincian_penjualan_buku = $this->penjualanBukuModel->getPenjualanBukuWithNamaBuku($start_date, $end_date);
    $rincian_gaji = $this->pembayaranGajiModel->getPembayaranGajiWithGuruu($start_date, $end_date);
    $rincian_pengeluaran = $this->pengeluaranModel->where("tanggal_beli >=", $start_date)
                                                  ->where("tanggal_beli <=", $end_date)
                                                  ->findAll();

    // Ambil total pendapatan
    $total_biaya_pendaftaran = $this->siswaModel->selectSum('biaya_pendaftaran')
                                                ->where("tanggal_pendaftaran >=", $start_date)
                                                ->where("tanggal_pendaftaran <=", $end_date)
                                                ->first()['biaya_pendaftaran'] ?? 0;
    $total_spp = $this->pembayaranSPPModel->selectSum('jumlah_pembayaran')
                                          ->where("tanggal_pembayaran >=", $start_date)
                                          ->where("tanggal_pembayaran <=", $end_date)
                                          ->first()['jumlah_pembayaran'] ?? 0;
    $total_penjualan_buku = $this->penjualanBukuModel->selectSum('total_harga')
                                                     ->where("tanggal_penjualan >=", $start_date)
                                                     ->where("tanggal_penjualan <=", $end_date)
                                                     ->first()['total_harga'] ?? 0;

    // Ambil total pengeluaran
    $total_gaji = $this->pembayaranGajiModel->selectSum('jumlah_gaji')
                                            ->where("tanggal_gajian >=", $start_date)
                                            ->where("tanggal_gajian <=", $end_date)
                                            ->first()['jumlah_gaji'] ?? 0;
    $total_pengeluaran = $this->pengeluaranModel->selectSum('harga')
                                                ->where("tanggal_beli >=", $start_date)
                                                ->where("tanggal_beli <=", $end_date)
                                                ->first()['harga'] ?? 0;

    // Hitung laba/rugi
    $total_pendapatan = $total_biaya_pendaftaran + $total_spp + $total_penjualan_buku;
    $total_pengeluaran_semua = $total_gaji + $total_pengeluaran;
    $laba_rugi = $total_pendapatan - $total_pengeluaran_semua;

    // Persiapkan spreadsheet
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Set judul
    $sheet->setCellValue('A1', 'Laporan Akuntansi');
    $sheet->setCellValue('A3', 'Rincian Pendapatan dan Pengeluaran');

    // Set header tabel
    $sheet->setCellValue('A5', 'Sumber');
    $sheet->setCellValue('B5', 'Pendapatan (Rp)');
    $sheet->setCellValue('C5', 'Pengeluaran (Rp)');

    // Isi data untuk biaya pendaftaran
    $row = 6; // Mulai dari baris 6 setelah header
    foreach ($rincian_biaya_pendaftaran as $item) {
        $sheet->setCellValue("A{$row}", "Biaya Pendaftaran - Nama " . esc($item['nama']));
        $sheet->setCellValue("B{$row}", number_format($item['biaya_pendaftaran'], 0, ',', '.'));
        $sheet->setCellValue("C{$row}", '');
        $row++;
    }

    // Isi data untuk pembayaran SPP
    foreach ($rincian_pembayaran_spp as $item) {
        $sheet->setCellValue("A{$row}", "Pembayaran SPP - Bulan " . esc($item['bulan']) . " - Nama " . esc($item['nama']));
        $sheet->setCellValue("B{$row}", number_format($item['jumlah_pembayaran'], 0, ',', '.'));
        $sheet->setCellValue("C{$row}", '');
        $row++;
    }

    // Isi data untuk penjualan buku
    foreach ($rincian_penjualan_buku as $item) {
        $sheet->setCellValue("A{$row}", "Penjualan Buku - " . esc($item['nama_buku']));
        $sheet->setCellValue("B{$row}", number_format($item['total_harga'], 0, ',', '.'));
        $sheet->setCellValue("C{$row}", '');
        $row++;
    }

    // Isi data untuk gaji guru
    foreach ($rincian_gaji as $item) {
        $sheet->setCellValue("A{$row}", "Gaji Guru - " . esc($item['nama_guru']));
        $sheet->setCellValue("B{$row}", '');
        $sheet->setCellValue("C{$row}", number_format($item['jumlah_gaji'], 0, ',', '.'));
        $row++;
    }

    // Isi data untuk pengeluaran
    foreach ($rincian_pengeluaran as $item) {
        $sheet->setCellValue("A{$row}", "Pengeluaran Barang - " . esc($item['nama_barang']));
        $sheet->setCellValue("B{$row}", '');
        $sheet->setCellValue("C{$row}", number_format($item['harga'], 0, ',', '.'));
        $row++;
    }

    // Tambahkan total dan laba/rugi di akhir tabel
    $sheet->setCellValue("A{$row}", 'Total');
    $sheet->setCellValue("B{$row}", number_format($total_pendapatan, 0, ',', '.'));
    $sheet->setCellValue("C{$row}", number_format($total_pengeluaran_semua, 0, ',', '.'));
    $row++;

    $sheet->setCellValue("A{$row}", 'Laba/Rugi');
    $sheet->setCellValue("B{$row}", ($laba_rugi >= 0) ? 'Laba: Rp. ' . number_format($laba_rugi, 0, ',', '.') : 'Rugi: Rp. ' . number_format(abs($laba_rugi), 0, ',', '.'));

    // Simpan dan kirim file ke browser
    $writer = new Xlsx($spreadsheet);
    $filename = 'Laporan_Akuntansi.xlsx';
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment; filename=\"$filename\"");
    header('Cache-Control: max-age=0');

    // Menyimpan file ke output
    $writer->save('php://output');
    exit;
}




public function exportPdf()
{
    // Ambil input rentang tanggal dari form
    $start_date = $this->request->getGet('start_date');
    $end_date = $this->request->getGet('end_date');
    // Jika tanggal tidak diberikan, gunakan tanggal default
    if (!$start_date) {
        $start_date = date('Y-m-01'); // Tanggal awal bulan ini
    }
    if (!$end_date) {
        $end_date = date('Y-m-d'); // Tanggal hari ini
    }

    // Ambil rincian pendapatan dan pengeluaran berdasarkan rentang tanggal
    $rincian_biaya_pendaftaran = $this->siswaModel->where("tanggal_pendaftaran >=", $start_date)
                                                  ->where("tanggal_pendaftaran <=", $end_date)
                                                  ->findAll();
    $rincian_pembayaran_spp = $this->siswaModel->getPembayaranSPPWithSiswa($start_date, $end_date);
    $rincian_penjualan_buku = $this->penjualanBukuModel->getPenjualanBukuWithNamaBuku($start_date, $end_date);
    $rincian_gaji = $this->pembayaranGajiModel->getPembayaranGajiWithGuruu($start_date, $end_date);
    $rincian_pengeluaran = $this->pengeluaranModel->where("tanggal_beli >=", $start_date)
                                                  ->where("tanggal_beli <=", $end_date)
                                                  ->findAll();

    // Ambil total pendapatan
    $total_biaya_pendaftaran = $this->siswaModel->selectSum('biaya_pendaftaran')
                                                ->where("tanggal_pendaftaran >=", $start_date)
                                                ->where("tanggal_pendaftaran <=", $end_date)
                                                ->first()['biaya_pendaftaran'] ?? 0;
    $total_spp = $this->pembayaranSPPModel->selectSum('jumlah_pembayaran')
                                          ->where("tanggal_pembayaran >=", $start_date)
                                          ->where("tanggal_pembayaran <=", $end_date)
                                          ->first()['jumlah_pembayaran'] ?? 0;
    $total_penjualan_buku = $this->penjualanBukuModel->selectSum('total_harga')
                                                     ->where("tanggal_penjualan >=", $start_date)
                                                     ->where("tanggal_penjualan <=", $end_date)
                                                     ->first()['total_harga'] ?? 0;

    // Ambil total pengeluaran
    $total_gaji = $this->pembayaranGajiModel->selectSum('jumlah_gaji')
                                            ->where("tanggal_gajian >=", $start_date)
                                            ->where("tanggal_gajian <=", $end_date)
                                            ->first()['jumlah_gaji'] ?? 0;
    $total_pengeluaran = $this->pengeluaranModel->selectSum('harga')
                                                ->where("tanggal_beli >=", $start_date)
                                                ->where("tanggal_beli <=", $end_date)
                                                ->first()['harga'] ?? 0;

    // Hitung laba/rugi
    $total_pendapatan = $total_biaya_pendaftaran + $total_spp + $total_penjualan_buku;
    $total_pengeluaran_semua = $total_gaji + $total_pengeluaran;
    $laba_rugi = $total_pendapatan - $total_pengeluaran_semua;

    // Persiapkan data untuk tampilan
    $data = [
        'rincian_biaya_pendaftaran' => $rincian_biaya_pendaftaran,
        'rincian_pembayaran_spp' => $rincian_pembayaran_spp,
        'rincian_penjualan_buku' => $rincian_penjualan_buku,
        'rincian_gaji' => $rincian_gaji,
        'rincian_pengeluaran' => $rincian_pengeluaran,
        'total_biaya_pendaftaran' => $total_biaya_pendaftaran,
        'total_spp' => $total_spp,
        'total_penjualan_buku' => $total_penjualan_buku,
        'total_gaji' => $total_gaji,
        'total_pengeluaran' => $total_pengeluaran,
        'total_pendapatan' => $total_pendapatan,
        'total_pengeluaran_semua' => $total_pengeluaran_semua,
        'laba_rugi' => $laba_rugi,
        'start_date' => $start_date,
        'end_date' => $end_date
    ];
    // Buat konten HTML untuk PDF dengan memuat view
    $html = view('dashboard/laporan_akuntansi/pdf_view', $data);

    // Inisialisasi Dompdf
    $options = new Options();
    $options->set('defaultFont', 'Courier');
    $dompdf = new Dompdf($options);

    // Load HTML ke Dompdf
    $dompdf->loadHtml($html);

    // (Opsional) Set ukuran dan orientasi kertas
    $dompdf->setPaper('A4', 'landscape');

    // Render PDF
    $dompdf->render();

    // Kirim PDF ke browser
    $dompdf->stream('laporan_akuntansi.pdf', ['Attachment' => true]);
    exit; // Hentikan script setelah file diekspor
}
    

}
