<?php

namespace App\Controllers;

use App\Models\PembayaranGajiModel;
use App\Models\GuruModel;

class PembayaranGajiController extends BaseController
{
    public function index()
    {
        $model = new PembayaranGajiModel();
    
        // Mengambil parameter pencarian
        $nama_guru = $this->request->getGet('nama_guru');
        $tanggal_mulai = $this->request->getGet('tanggal_mulai');
        $tanggal_selesai = $this->request->getGet('tanggal_selesai');
    
        // Mengambil data berdasarkan parameter pencarian
        $data['pembayaran_gaji'] = $model->searchPembayaranGaji($nama_guru, $tanggal_mulai, $tanggal_selesai);
    
        // Menambahkan nilai parameter pencarian ke dalam data yang akan dikirim ke view
        $data['nama_guru'] = $nama_guru;
        $data['tanggal_mulai'] = $tanggal_mulai;
        $data['tanggal_selesai'] = $tanggal_selesai;
    
        // Load view untuk menampilkan data
        return view('dashboard/pembayaran_gaji/index', $data);
    }
    


    public function tambah()
{
    $guruModel = new \App\Models\GuruModel();
    $data['guru'] = $guruModel->findAll(); // Mengambil semua data guru untuk dropdown
    return view('dashboard/pembayaran_gaji/tambah', $data);
}

public function store()
{
    $pembayaranModel = new PembayaranGajiModel();
    $data = [
        'id_guru' => $this->request->getPost('id_guru'),
        'jumlah_gaji' => $this->request->getPost('jumlah_gaji'),
        'tanggal_gajian' => $this->request->getPost('tanggal_gajian'),
        'keterangan' => $this->request->getPost('keterangan'),
    ];
    
    $pembayaranModel->insert($data);
    return redirect()->to(base_url('pembayaran_gaji'));
}
public function edit($id)
{
    $pembayaranModel = new PembayaranGajiModel();
    $guruModel = new GuruModel();

    $data['pembayaran_gaji'] = $pembayaranModel->find($id);
    $data['guru'] = $guruModel->findAll();

    return view('dashboard/pembayaran_gaji/edit', $data);
}

public function update($id)
{
    $pembayaranModel = new PembayaranGajiModel();
    
    $data = [
        'id_guru' => $this->request->getPost('id_guru'),
        'jumlah_gaji' => $this->request->getPost('jumlah_gaji'),
        'tanggal_gajian' => $this->request->getPost('tanggal_gajian'),
        'keterangan' => $this->request->getPost('keterangan'),
    ];

    $pembayaranModel->update($id, $data);
    return redirect()->to(base_url('pembayaran_gaji'));
}

public function hapus($id)
{
    $pembayaranModel = new PembayaranGajiModel();
    $pembayaranModel->delete($id);

    return redirect()->to(base_url('pembayaran_gaji'));
}

public function exportToExcel()
{
    $model = new PembayaranGajiModel();

    // Mengambil parameter pencarian
    $nama_guru = $this->request->getGet('nama_guru');
    $tanggal_mulai = $this->request->getGet('tanggal_mulai');
    $tanggal_selesai = $this->request->getGet('tanggal_selesai');

    // Memanggil model untuk mendapatkan data dengan filter
    $data['pembayaran_gaji'] = $model->searchPembayaranGaji($nama_guru, $tanggal_mulai, $tanggal_selesai);

    // Panggil fungsi untuk membuat file Excel (gunakan PhpSpreadsheet)
    // Misal Anda menggunakan PhpSpreadsheet untuk membuat file Excel
    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setTitle('Data Pembayaran Gaji');

    // Set header
    $sheet->setCellValue('A1', 'ID');
    $sheet->setCellValue('B1', 'Nama Guru');
    $sheet->setCellValue('C1', 'Jumlah Gaji');
    $sheet->setCellValue('D1', 'Tanggal Gajian');
    $sheet->setCellValue('E1', 'Keterangan');

    // Isi data
    $row = 2; // Mulai dari baris kedua
    foreach ($data['pembayaran_gaji'] as $p) {
        $sheet->setCellValue('A' . $row, $p['id_pembayaran_gaji']);
        $sheet->setCellValue('B' . $row, $p['nama_guru']);
        $sheet->setCellValue('C' . $row, $p['jumlah_gaji']);
        $sheet->setCellValue('D' . $row, $p['tanggal_gajian']);
        $sheet->setCellValue('E' . $row, $p['keterangan']);
        $row++;
    }

    // Output to browser
    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
    $filename = 'Data_Pembayaran_Gaji_' . date('Ymd') . '.xlsx';
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    $writer->save('php://output');
}

public function exportToPDF()
{
    $model = new PembayaranGajiModel();

    // Mengambil parameter pencarian
    $nama_guru = $this->request->getGet('nama_guru');
    $tanggal_mulai = $this->request->getGet('tanggal_mulai');
    $tanggal_selesai = $this->request->getGet('tanggal_selesai');

    // Memanggil model untuk mendapatkan data dengan filter
    $data['pembayaran_gaji'] = $model->searchPembayaranGaji($nama_guru, $tanggal_mulai, $tanggal_selesai);

    // Panggil fungsi untuk membuat file PDF (gunakan dompdf)
    $pdf = new \Dompdf\Dompdf();
    $html = view('dashboard/pembayaran_gaji/pdf', $data);
    $pdf->loadHtml($html);
    $pdf->setPaper('A4', 'landscape');
    $pdf->render();
    $filename = 'Data_Pembayaran_Gaji_' . date('Ymd') . '.pdf';
    $pdf->stream($filename, ['Attachment' => true]);
}
}
