<?php 

namespace App\Controllers;


use App\Models\PengeluaranModel; // Import model
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Dompdf\Dompdf;

class PengeluaranController extends BaseController
{
    protected $pengeluaranModel;

    public function __construct()
    {
        $this->pengeluaranModel = new PengeluaranModel(); // Membuat instance model
    }

    // Menampilkan daftar pengeluaran
    public function index()
    {
        $model = new PengeluaranModel(); // Buat instance model
        $tanggalMulai = $this->request->getGet('tanggal_mulai');
        $tanggalSelesai = $this->request->getGet('tanggal_selesai');
    
        // Gunakan metode baru untuk mendapatkan data berdasarkan rentang tanggal
        $data['pengeluaran'] = $model->getPengeluaranByDateRange($tanggalMulai, $tanggalSelesai);

         // Menambahkan nilai parameter pencarian ke dalam data yang akan dikirim ke view
    $data['tanggal_mulai'] = $tanggalMulai;
    $data['tanggal_selesai'] = $tanggalSelesai;
    
        return view('dashboard/pengeluaran/index', $data); // Kirim data ke view
    }
    

    // Menampilkan form tambah pengeluaran
    public function tambah()
    {
        return view('dashboard/pengeluaran/tambah'); // Tampilkan form tambah
    }

    // Proses tambah pengeluaran
    public function store()
    {
        $this->pengeluaranModel->save([
            'nama_barang' => $this->request->getPost('nama_barang'),
            'toko' => $this->request->getPost('toko'),
            'keterangan' => $this->request->getPost('keterangan'),
            'jumlah' => $this->request->getPost('jumlah'),
            'harga' => $this->request->getPost('harga'),
            'tanggal_beli' => $this->request->getPost('tanggal_beli'),
        ]);
        
        return redirect()->to('/pengeluaran'); // Redirect ke halaman pengeluaran setelah berhasil
    }

    // Menampilkan form edit pengeluaran
    public function edit($id)
    {
        $data['pengeluaran'] = $this->pengeluaranModel->find($id); // Ambil data pengeluaran berdasarkan ID
        return view('dashboard/pengeluaran/edit', $data); // Tampilkan form edit
    }

    // Proses edit pengeluaran
    public function update($id)
    {
        $this->pengeluaranModel->update($id, [
            'nama_barang' => $this->request->getPost('nama_barang'),
            'toko' => $this->request->getPost('toko'),
            'keterangan' => $this->request->getPost('keterangan'),
            'jumlah' => $this->request->getPost('jumlah'),
            'harga' => $this->request->getPost('harga'),
            'tanggal_beli' => $this->request->getPost('tanggal_beli'),
        ]);
        
        return redirect()->to('/pengeluaran'); // Redirect ke halaman pengeluaran setelah berhasil
    }

    // Menghapus pengeluaran
    public function hapus($id)
    {
        $this->pengeluaranModel->delete($id); // Hapus data berdasarkan ID
        return redirect()->to('/pengeluaran'); // Redirect ke halaman pengeluaran setelah berhasil
    }

    public function exportToExcel()
    {
        $model = new PengeluaranModel();
        
        // Mengambil parameter pencarian
        $tanggal_mulai = $this->request->getGet('tanggal_mulai');
        $tanggal_selesai = $this->request->getGet('tanggal_selesai');

        // Memanggil model untuk mendapatkan data dengan filter
        $data['pengeluaran'] = $model->getPengeluaranByDateRange($tanggal_mulai, $tanggal_selesai);

        // Membuat file Excel
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Data Pengeluaran');

        // Set header
        $sheet->setCellValue('A1', 'ID');
        $sheet->setCellValue('B1', 'Nama Barang');
        $sheet->setCellValue('C1', 'Toko');
        $sheet->setCellValue('D1', 'Keterangan');
        $sheet->setCellValue('E1', 'Jumlah');
        $sheet->setCellValue('F1', 'Harga');
        $sheet->setCellValue('G1', 'Tanggal Beli');

        // Isi data
        $row = 2; // Mulai dari baris kedua
        foreach ($data['pengeluaran'] as $p) {
            $sheet->setCellValue('A' . $row, $p['id_pengeluaran']);
            $sheet->setCellValue('B' . $row, $p['nama_barang']);
            $sheet->setCellValue('C' . $row, $p['toko']);
            $sheet->setCellValue('D' . $row, $p['keterangan']);
            $sheet->setCellValue('E' . $row, $p['jumlah']);
            $sheet->setCellValue('F' . $row, $p['harga']);
            $sheet->setCellValue('G' . $row, $p['tanggal_beli']);
            $row++;
        }

        // Output to browser
        $writer = new Xlsx($spreadsheet);
        $filename = 'Data_Pengeluaran_' . date('Ymd') . '.xlsx';
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        $writer->save('php://output');
    }

    public function exportToPDF()
    {
        $model = new PengeluaranModel();

        // Mengambil parameter pencarian
        $tanggal_mulai = $this->request->getGet('tanggal_mulai');
        $tanggal_selesai = $this->request->getGet('tanggal_selesai');

        // Memanggil model untuk mendapatkan data dengan filter
        $data['pengeluaran'] = $model->getPengeluaranByDateRange($tanggal_mulai, $tanggal_selesai);

        // Membuat file PDF
        $pdf = new Dompdf();
        $html = view('dashboard/pengeluaran/pdf', $data);
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'landscape');
        $pdf->render();
        $filename = 'Data_Pengeluaran_' . date('Ymd') . '.pdf';
        $pdf->stream($filename, ['Attachment' => true]);
    }
}
