<?php

namespace App\Models;

use CodeIgniter\Model;

class PembayaranSppModel extends Model
{
    protected $table = 'pembayaran_spp';
    protected $primaryKey = 'id_pembayaran';
    protected $allowedFields = ['id_siswa', 'bulan', 'tahun', 'jumlah_pembayaran', 'tanggal_pembayaran', 'metode_pembayaran', 'status', 'keterangan'];

    // Method untuk mengambil data pembayaran dengan informasi siswa
    public function getPembayaranWithSiswa()
    {
        return $this->select('pembayaran_spp.*, siswa.nama AS nama_siswa')
                    ->join('siswa', 'siswa.id_siswa = pembayaran_spp.id_siswa')
                    ->orderBy('pembayaran_spp.tanggal_pembayaran', 'DESC')
                    ->findAll();
    }
    

    // Method untuk mencari data pembayaran berdasarkan nama, tahun, dan bulan
    public function searchPembayaran($nama = null, $tahun = null, $bulan = null)
    {
        $this->select('pembayaran_spp.*, siswa.nama AS nama_siswa')
             ->join('siswa', 'siswa.id_siswa = pembayaran_spp.id_siswa');

        if ($nama) {
            $this->like('siswa.nama', $nama);
        }

        if ($tahun) {
            $this->where('pembayaran_spp.tahun', $tahun);
        }

        if ($bulan) {
            $this->where('pembayaran_spp.bulan', $bulan);
        }

        return $this->findAll();
    }
     // Method untuk mengambil riwayat pembayaran berdasarkan id_siswa dan status
     public function getRiwayatPembayaran($id_siswa, $tahun = null)
     {
         $this->select('pembayaran_spp.*, siswa.nama AS nama_siswa')
              ->join('siswa', 'siswa.id_siswa = pembayaran_spp.id_siswa')
              ->where('pembayaran_spp.id_siswa', $id_siswa);
 
         if ($tahun) {
             $this->where('pembayaran_spp.tahun', $tahun);
         }
 
         return $this->findAll();
     }

     public function searchPembayarann($nama = null, $tahun = null, $bulan = null)
{
    $builder = $this->db->table('pembayaran_spp')
                        ->select('pembayaran_spp.*, siswa.nama AS nama_siswa')
                        ->join('siswa', 'siswa.id_siswa = pembayaran_spp.id_siswa');

    if (!empty($nama)) {
        $builder->like('siswa.nama', $nama);
    }

    if (!empty($tahun)) {
        $builder->where('pembayaran_spp.tahun', $tahun);
    }

    if (!empty($bulan)) {
        $builder->where('pembayaran_spp.bulan', $bulan);
    }

    return $builder->get()->getResultArray();
}

public function getPembayaranSPPWithSiswa($start_date, $end_date)
{
    return $this->db->table($this->table)
        ->select('siswa.nama, pembayaran_spp.*')
        ->join('siswa', 'siswa.id_siswa = pembayaran_spp.id_siswa')
        ->where("tanggal_pembayaran >=", $start_date)
        ->where("tanggal_pembayaran <=", $end_date)
        ->get()
        ->getResultArray();
}
}
