<?php 
namespace App\Models;

use CodeIgniter\Model;

class PengeluaranModel extends Model
{
    protected $table = 'pengeluaran';
    protected $primaryKey = 'id_pengeluaran';
    protected $allowedFields = ['nama_barang', 'toko', 'keterangan', 'jumlah', 'harga', 'tanggal_beli'];

    public function getPengeluaran()
    {
        return $this->findAll();
    }

    public function getPengeluaranByDateRange($tanggal_mulai = null, $tanggal_selesai = null)
    {
        if ($tanggal_mulai) {
            $this->where('tanggal_beli >=', $tanggal_mulai);
        }

        if ($tanggal_selesai) {
            $this->where('tanggal_beli <=', $tanggal_selesai);
        }

        return $this->findAll();
    }

    public function getPengeluaranWithNamaBarang($start_date, $end_date)
    {
        return $this->db->table($this->table)
            ->where("tanggal_beli >=", $start_date)
            ->where("tanggal_beli <=", $end_date)
            ->get()
            ->getResultArray();
    }
}
