<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
        <?= view('layouts/sidebarsuperadmin') ?>
                <!-- Content Wrapper -->
                <div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col-sm-6">
                    <h1 class="mt-4">Edit Guru</h1>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card shadow-sm">
                        <div class="card-header bg-info text-white">
                            <h4 class="mb-0">Form Edit Data Guru</h4>
                        </div>
                        <div class="card-body">
                            <form action="<?= base_url('guru/update/' . $guru['id_guru']) ?>" method="post">
                                <?= csrf_field() ?>
                                
                                <div class="form-group">
                                    <label for="nama_guru">Nama Guru</label>
                                    <input type="text" class="form-control" id="nama_guru" name="nama_guru" value="<?= esc($guru['nama_guru']) ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="tanggal_ulang_tahun">Tanggal Ulang Tahun</label>
                                    <input type="date" class="form-control" id="tanggal_ulang_tahun" name="tanggal_ulang_tahun" value="<?= esc($guru['tanggal_ulang_tahun']) ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="instagram">Instagram</label>
                                    <input type="text" class="form-control" id="instagram" name="instagram" value="<?= esc($guru['instagram']) ?>">
                                </div>
                                
                                <button type="submit" class="btn btn-success btn-block">Update</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

        <!-- /.content-wrapper -->                   
    </div>
     <?php else: ?>
     <div class="alert alert-danger">
     <h4>Anda tidak memiliki akses ke halaman ini.</h4>
     </div>
    <?php endif; ?>
    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
    <!-- jQuery -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>


</body>
</html>
