<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
            <?= view('layouts/sidebarsuperadmin') ?>
            <!-- Content Wrapper -->
            <div class="content-wrapper">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6">
                                <h1 class="mb-4">Daftar Pembayaran SPP</h1>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Main content -->
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">

                                 <!-- Tombol Tambah Pembayaran -->
                                 <a href="<?= base_url('pembayaran_spp/create') ?>" class="btn btn-primary mb-3">Tambah Pembayaran SPP</a>

<!-- Form Cari Pembayaran -->
<form action="<?= site_url('pembayaran_spp/search') ?>" method="get" class="mb-4">
    <div class="row mb-3  border p-3">
        <div class="col-md-3">
            <input type="text" name="nama" class="form-control" placeholder="Nama Siswa" />
        </div>
        <div class="col-md-3">
            <input type="text" name="tahun" class="form-control" placeholder="Tahun" />
        </div>
        <div class="col-md-3">
            <select name="bulan" class="form-control">
                <option value="">Pilih Bulan</option>
                <!-- Daftar bulan -->
                <?php 
                $months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
                foreach ($months as $month) {
                    echo "<option value='$month'>$month</option>";
                }
                ?>
            </select>
        </div>
        <div class="col-md-3">
            <button type="submit" class="btn btn-success">Cari</button>
        </div>
    </div>
</form>

<div class="mb-mb-3 border p-3">
                                <!-- Tombol untuk membuka popup modal (Export Excel) -->
                                <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#exportModal">
                                    Export Excel
                                </button>

                                <!-- Modal untuk Export Excel -->
                                <div class="modal fade" id="exportModal" tabindex="-1" role="dialog" aria-labelledby="exportModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exportModalLabel">Export Riwayat Pembayaran ke Excel</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form id="exportForm" action="<?= base_url('pembayaran_spp/export_excel') ?>" method="post">
                                                    <div class="form-group">
                                                        <label for="nama_export">Nama Siswa:</label>
                                                        <input type="text" name="nama" id="nama_export" class="form-control" placeholder="Nama Siswa" />
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="bulan_export">Bulan:</label>
                                                        <select name="bulan" class="form-control">
                                                            <option value="">Pilih Bulan</option>
                                                            <option value="Januari">Januari</option>
                                                            <option value="Februari">Februari</option>
                                                            <option value="Maret">Maret</option>
                                                            <option value="April">April</option>
                                                            <option value="Mei">Mei</option>
                                                            <option value="Juni">Juni</option>
                                                            <option value="Juli">Juli</option>
                                                            <option value="Agustus">Agustus</option>
                                                            <option value="September">September</option>
                                                            <option value="Oktober">Oktober</option>
                                                            <option value="November">November</option>
                                                            <option value="Desember">Desember</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="tahun_export">Tahun:</label>
                                                        <input type="number" name="tahun" id="tahun_export" class="form-control" placeholder="Tahun" />
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                                                <button type="submit" class="btn btn-success" form="exportForm">Export</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tombol untuk membuka popup modal (Export PDF) -->
                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#exportPdfModal">
                                    Export PDF
                                </button>

                                <!-- Modal untuk Export PDF -->
                                <div class="modal fade" id="exportPdfModal" tabindex="-1" role="dialog" aria-labelledby="exportPdfModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exportPdfModalLabel">Export Riwayat Pembayaran ke PDF</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form id="exportPdfForm" action="<?= base_url('pembayaran_spp/export_pdf') ?>" method="post">
                                                    <div class="form-group">
                                                        <label for="tahun_export_pdf">Tahun:</label>
                                                        <input type="number" name="tahun" id="tahun_export_pdf" class="form-control" placeholder="Tahun" />
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="bulan_export_pdf">Bulan:</label>
                                                        <select name="bulan" class="form-control">
                                                            <option value="">Pilih Bulan</option>
                                                            <option value="Januari">Januari</option>
                                                            <option value="Februari">Februari</option>
                                                            <option value="Maret">Maret</option>
                                                            <option value="April">April</option>
                                                            <option value="Mei">Mei</option>
                                                            <option value="Juni">Juni</option>
                                                            <option value="Juli">Juli</option>
                                                            <option value="Agustus">Agustus</option>
                                                            <option value="September">September</option>
                                                            <option value="Oktober">Oktober</option>
                                                            <option value="November">November</option>
                                                            <option value="Desember">Desember</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="nama_export_pdf">Nama Siswa (opsional):</label>
                                                        <input type="text" name="nama" id="nama_export_pdf" class="form-control" placeholder="Nama Siswa" />
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                                                <button type="submit" class="btn btn-danger" form="exportPdfForm">Export</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                                <!-- Pengaturan Pagination -->
                                <?php
// Pengaturan Pagination
$items_per_page = 12; // Jumlah item yang ditampilkan per halaman
$total_items = count($pembayaran_spp); // Total item
$total_pages = ceil($total_items / $items_per_page); // Total halaman

// Halaman saat ini (default adalah 1)
$current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

// Pastikan halaman saat ini dalam rentang yang valid
if ($current_page < 1) $current_page = 1;
if ($current_page > $total_pages) $current_page = $total_pages;

// Hitung indeks awal untuk halaman saat ini
$start_index = ($current_page - 1) * $items_per_page;

// Batasi data yang ditampilkan untuk halaman saat ini
$limited_pembayaran = array_slice($pembayaran_spp, $start_index, $items_per_page);

// Ambil query string saat ini (parameter GET) kecuali 'page' untuk menjaga parameter lainnya tetap utuh
$queryString = $_SERVER['QUERY_STRING'];

// Hapus parameter 'page' yang ada dari query string
$queryString = preg_replace('/(\?|&)page=\d+/', '', $queryString);

// Tambahkan '&' jika query string ada, atau mulai dengan '?'
$queryString = ($queryString) ? '?' . $queryString . '&' : '?page=';
?>


                                 <!-- Tabel data siswa -->
                                 <div class="table-responsive">
                                    <table class="table table-striped table-bordered">
                                        <thead class="thead-dark">
                                        <tr>
                                            <th>ID Pembayaran</th>
                                            <th>ID Siswa</th>
                                            <th>Bulan</th>
                                            <th>Tahun</th>
                                            <th>Jumlah Pembayaran</th>
                                            <th>Tanggal Pembayaran</th>
                                            <th>Metode Pembayaran</th>
                                            <th>Status</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php if (!empty($limited_pembayaran)): ?>
                                        <?php foreach ($limited_pembayaran as $pembayaran): ?>
                                            <tr>
                                                <td><?= $pembayaran['id_pembayaran'] ?></td>
                                                <td><?= $pembayaran['id_siswa'] ?></td>
                                                <td><?= $pembayaran['bulan'] ?></td>
                                                <td><?= $pembayaran['tahun'] ?></td>
                                                <td>Rp. <?= number_format($pembayaran['jumlah_pembayaran'], 0, ',', '.') ?></td>
                                                <td><?= $pembayaran['tanggal_pembayaran'] ?></td>
                                                <td><?= $pembayaran['metode_pembayaran'] ?></td>
                                                <td><?= $pembayaran['status'] ?></td>
                                                <td>
                                                    <a href="<?= base_url('pembayaran_spp/edit/' . $pembayaran['id_pembayaran']) ?>" class="btn btn-warning btn-sm">Edit</a>
                                                    <a href="<?= base_url('pembayaran_spp/delete/' . $pembayaran    ['id_pembayaran']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Hapus</a>

                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                        <?php else: ?>
            <tr>
                <td colspan="10" class="text-center">Tidak ada data pembayaran</td>
            </tr>
        <?php endif; ?>
                                    </tbody>
                                </table>

                                </div>
<!-- Navigasi Pagination -->
<nav aria-label="Navigasi halaman">
    <ul class="pagination justify-content-center">
        <!-- Tombol Sebelumnya -->
        <li class="page-item <?= ($current_page == 1) ? 'disabled' : '' ?>">
            <a class="page-link" href="<?= $queryString ?>page=<?= $current_page - 1 ?>" aria-label="Sebelumnya">
                <span aria-hidden="true">&laquo;</span>
            </a>
        </li>

        <!-- Link Nomor Halaman -->
        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
            <li class="page-item <?= ($current_page == $i) ? 'active' : '' ?>">
                <a class="page-link" href="<?= $queryString ?>page=<?= $i ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>

        <!-- Tombol Selanjutnya -->
        <li class="page-item <?= ($current_page == $total_pages) ? 'disabled' : '' ?>">
            <a class="page-link" href="<?= $queryString ?>page=<?= $current_page + 1 ?>" aria-label="Selanjutnya">
                <span aria-hidden="true">&raquo;</span>
            </a>
        </li>
    </ul>
</nav>

                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- /.content-wrapper -->
            </div>
    <?php else: ?>
        <div class="alert alert-danger">
            <h4>Anda tidak memiliki akses ke halaman ini!</h4>
        </div>
    <?php endif; ?>
    <!-- /.wrapper -->
  <!-- Bootstrap & AdminLTE JS -->
  <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
    <!-- jQuery -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
</body>
</html>
