<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Data Pengeluaran</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
    </style>
</head>
<body>
    <h2>Data Pengeluaran</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Nama Barang</th>
                <th>Toko</th>
                <th>Keterangan</th>
                <th>Jumlah</th>
                <th>Harga</th>
                <th>Tanggal Beli</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($pengeluaran) && is_array($pengeluaran)): ?>
                <?php foreach ($pengeluaran as $p): ?>
                    <tr>
                        <td><?= esc($p['id_pengeluaran']) ?></td>
                        <td><?= esc($p['nama_barang']) ?></td>
                        <td><?= esc($p['toko']) ?></td>
                        <td><?= esc($p['keterangan']) ?></td>
                        <td><?= esc($p['jumlah']) ?></td>
                        <td><?= 'Rp ' . number_format($p['harga'], 0, ',', '.') ?></td>
                        <td><?= date('d-m-Y', strtotime($p['tanggal_beli'])) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" class="text-center">Data tidak ditemukan.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>
