<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">
        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'petugas'): ?>
            <?= view('layouts/sidebarpetugas') ?>
            
            <!-- Content Wrapper -->
            <div class="content-wrapper">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6">
                                <h1 class="m-0">Dashboard</h1>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main content -->
                <section class="content">
                    <div class="container-fluid">
                        <div class="row justify-content-center">
                            <div class="col-md-8">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Tambah Data Siswa</h3>
                                    </div>
                                    <div class="card-body">
                                        <form action="<?= base_url('siswa/store') ?>" method="post">
                                            <div class="form-group">
                                                <label>Nama</label>
                                                <input type="text" name="nama" class="form-control" required>
                                            </div>
                                            <div class="form-group">
                                                <label>Tanggal Lahir</label>
                                                <input type="date" name="tanggal_lahir" class="form-control" required>
                                            </div>
                                            <div class="form-group">
                                                <label>Nama Orang Tua</label>
                                                <input type="text" name="nama_org_tua" class="form-control" required>
                                            </div>
                                            <div class="form-group">
                                                <label>Alamat</label>
                                                <textarea name="alamat" class="form-control" required></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label>No HP</label>
                                                <input type="text" name="no_hp" class="form-control" required>
                                            </div>
                                            <div class="form-group">
                                                <label>Akun Instagram</label>
                                                <input type="text" name="akun_instagram" class="form-control">
                                            </div>
                                            <div class="form-group">
                                                <label>Tanggal Pendaftaran</label>
                                                <input type="date" name="tanggal_pendaftaran" class="form-control" required>
                                            </div>
                                            <div class="form-group">
                                                <label for="kelas">Guru</label>
                                                <select name="kelas" class="form-control" id="kelas" required>
                                                    <option value="">Pilih Guru</option>
                                                    <?php foreach ($guru as $g): ?>
                                                        <option value="<?= $g['id_guru'] ?>"><?= $g['nama_guru'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label>Biaya Pendaftaran</label>
                                                <input type="text" name="biaya_pendaftaran" class="form-control" required>
                                            </div>
                                            <div class="form-group">
                                                <label>Status</label>
                                                <select name="status" class="form-control" required>
                                                    <option value="">Pilih Status</option>
                                                    <option value="aktif">Aktif</option>
                                                    <option value="tidak aktif">Tidak Aktif</option>
                                                </select>
                                            </div>
                                            <button type="submit" class="btn btn-primary">Simpan</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- /.content -->
            </div>
            <!-- /.content-wrapper -->
        <?php else: ?>
            <div class="alert alert-danger">
                <h4>Anda tidak memiliki akses ke halaman ini.</h4>
            </div>
        <?php endif; ?>
    </div>
    <!-- /.wrapper -->

    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
</body>
</html>
