<?php

namespace App\Controllers;

use App\Models\BukuModel;
use CodeIgniter\Controller;

class BukuController extends Controller
{
    protected $bukuModel;

    public function __construct()
    {
        $this->bukuModel = new BukuModel();
    }

    // Menampilkan data buku
    public function index()
    {
        $data['buku'] = $this->bukuModel->findAll(); // Ambil semua data buku
        return view('dashboard/buku/index', $data); // Tampilkan ke view
    }

    // Menampilkan form untuk menambah buku
    public function create()
    {
        return view('dashboard/buku/create');
    }

    // Menyimpan buku baru
    public function store()
    {
        $data = [
            'nama_buku'      => $this->request->getPost('nama_buku'),
            'harga'          => $this->request->getPost('harga'),
            'tanggal_stock'  => $this->request->getPost('tanggal_stock'),
            'stok'           => $this->request->getPost('stok'),
            'keterangan'     => $this->request->getPost('keterangan'),
        ];

        $this->bukuModel->insert($data); // Simpan data buku ke database

        return redirect()->to('/data-Buku'); // Kembali ke halaman index buku
    }

    // Menampilkan form edit buku
    public function edit($id)
    {
        $data['buku'] = $this->bukuModel->find($id); // Ambil data buku berdasarkan ID

        return view('dashboard/buku/edit', $data); // Tampilkan ke view
    }

    // Mengupdate data buku
    public function update($id)
    {
        $data = [
            'nama_buku'      => $this->request->getPost('nama_buku'),
            'harga'          => $this->request->getPost('harga'),
            'tanggal_stock'  => $this->request->getPost('tanggal_stock'),
            'stok'           => $this->request->getPost('stok'),
            'keterangan'     => $this->request->getPost('keterangan'),
        ];

        $this->bukuModel->update($id, $data); // Update data buku ke database

        return redirect()->to('/data-Buku'); // Kembali ke halaman index buku
    }

    // Menghapus buku
    public function delete($id)
    {
        $this->bukuModel->delete($id); // Hapus data buku berdasarkan ID

        return redirect()->to('/data-Buku'); // Kembali ke halaman index buku
    }
    
    // Menangani pengurangan stok ketika penjualan terjadi
    public function kurangiStok($id, $jumlah)
    {
        $buku = $this->bukuModel->find($id); // Ambil data buku berdasarkan ID

        if ($buku['stok'] >= $jumlah) {
            $buku['stok'] -= $jumlah; // Kurangi stok buku
            $this->bukuModel->update($id, $buku); // Update stok buku
        } else {
            // Jika stok habis, buat logikanya di sini (misal menampilkan pesan atau popup)
            return redirect()->back()->with('error', 'Stok buku habis!');
        }

        return redirect()->to('/data-Buku'); // Kembali ke halaman index buku
    }
}
