
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

public function exportExcel($id_siswa)
{
    $model = new PembayaranSppModel();
    $riwayatPembayaran = $model->getRiwayatPembayaran($id_siswa);

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setCellValue('A1', 'Tahun');
    $sheet->setCellValue('B1', 'Bulan');
    $sheet->setCellValue('C1', 'Tanggal Pembayaran');
    $sheet->setCellValue('D1', 'Jumlah Pembayaran');
    $sheet->setCellValue('E1', 'Status');
    $sheet->setCellValue('F1', 'Keterangan');

    $row = 2;
    foreach ($riwayatPembayaran as $pembayaran) {
        $sheet->setCellValue('A' . $row, $pembayaran['tahun']);
        $sheet->setCellValue('B' . $row, $pembayaran['bulan']);
        $sheet->setCellValue('C' . $row, $pembayaran['tanggal_pembayaran']);
        $sheet->setCellValue('D' . $row, $pembayaran['jumlah_pembayaran']);
        $sheet->setCellValue('E' . $row, $pembayaran['status']);
        $sheet->setCellValue('F' . $row, $pembayaran['keterangan']);
        $row++;
    }

    $writer = new Xlsx($spreadsheet);
    $filename = 'Riwayat Pembayaran SPP.xlsx';

    // Direct download ke browser
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Cache-Control: max-age=0');
    $writer->save('php://output');
    exit;
}
