<?php

namespace App\Controllers;

use App\Models\SiswaModel;
use App\Models\PembayaranSppModel; // Pastikan untuk mengganti dengan model yang sesuai
use CodeIgniter\Controller;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Dompdf\Dompdf;

class SiswaController extends Controller
{
    protected $siswaModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
    }

    // Menampilkan data siswa
    public function index()
    {
        $nama = $this->request->getGet('nama');
        $status = $this->request->getGet('status');

        $query = $this->siswaModel;

        if ($nama) {
            $query = $query->like('nama', $nama);
        }

        if ($status) {
            $query = $query->where('status', $status);
        }

        $data['siswa'] = $query->findAll();

        return view('dashboard/siswa/index', $data); // Ganti dengan view yang sesuai
    }

    public function Riwayat_spp()
    {
        $nama = $this->request->getGet('nama');
        $status = $this->request->getGet('status');

        $query = $this->siswaModel;

        if ($nama) {
            $query = $query->like('nama', $nama);
        }

        if ($status) {
            $query = $query->where('status', $status);
        }

        $data['siswa'] = $query->findAll();

        return view('dashboard/Riwayat_spp/index', $data); // Ganti dengan view yang sesuai
    }

    // Menampilkan form tambah data siswa
    public function create()
    {
        return view('dashboard/siswa/create'); // Ganti dengan view yang sesuai
    }

    // Menyimpan data siswa
    public function store()
    {
        $this->siswaModel->save([
            'nama' => $this->request->getPost('nama'),
            'tanggal_lahir' => $this->request->getPost('tanggal_lahir'),
            'nama_org_tua' => $this->request->getPost('nama_org_tua'),
            'alamat' => $this->request->getPost('alamat'),
            'no_hp' => $this->request->getPost('no_hp'),
            'akun_instagram' => $this->request->getPost('akun_instagram'),
            'tanggal_pendaftaran' => $this->request->getPost('tanggal_pendaftaran'),
            'biaya_pendaftaran' => $this->request->getPost('biaya_pendaftaran'),
            'status' => $this->request->getPost('status'),
        ]);

        return redirect()->to(base_url('siswa'));
    }

    // Menampilkan form edit data siswa
    public function edit($id)
    {
        $data['siswa'] = $this->siswaModel->find($id);
        return view('dashboard/siswa/edit', $data); // Ganti dengan view yang sesuai
    }

    // Mengupdate data siswa
    public function update($id)
    {
        $this->siswaModel->update($id, [
            'nama' => $this->request->getPost('nama'),
            'tanggal_lahir' => $this->request->getPost('tanggal_lahir'),
            'nama_org_tua' => $this->request->getPost('nama_org_tua'),
            'alamat' => $this->request->getPost('alamat'),
            'no_hp' => $this->request->getPost('no_hp'),
            'akun_instagram' => $this->request->getPost('akun_instagram'),
            'tanggal_pendaftaran' => $this->request->getPost('tanggal_pendaftaran'),
            'biaya_pendaftaran' => $this->request->getPost('biaya_pendaftaran'),
            'status' => $this->request->getPost('status'),
        ]);

        return redirect()->to(base_url('siswa'));
    }

   // Menghapus data siswa
   public function delete($id_siswa)
    {
        $siswaModel = new SiswaModel();
        $pembayaranModel = new PembayaranSppModel(); // Pastikan Anda memiliki model untuk tabel pembayaran
    
        // Cek apakah siswa dengan ID tersebut ada
        if ($siswaModel->find($id_siswa)) {
            // Hapus data terkait di tabel pembayaran_spp
            $pembayaranModel->where('id_siswa', $id_siswa)->delete();
    
            // Hapus data siswa berdasarkan ID
            $siswaModel->delete($id_siswa);
    
            // Redirect ke halaman daftar siswa dengan pesan sukses
            return redirect()->to(base_url('siswa'))->with('status', 'Siswa berhasil dihapus');
        } else {
            // Jika ID tidak ditemukan, tampilkan pesan error
            return redirect()->to(base_url('siswa'))->with('status', 'Siswa tidak ditemukan');
        }
    }


    // Ekspor ke Excel
    public function exportExcel()
    {
        $nama = $this->request->getGet('nama');
        $status = $this->request->getGet('status');

        $query = $this->siswaModel;

        if ($nama) {
            $query = $query->like('nama', $nama);
        }

        if ($status) {
            $query = $query->where('status', $status);
        }

        $siswaData = $query->findAll();

        // Load PHPExcel library
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('Data Siswa');

        // Set Header
        $sheet->setCellValue('A1', 'Nama');
        $sheet->setCellValue('B1', 'Tanggal Lahir');
        $sheet->setCellValue('C1', 'Nama Orang Tua');
        $sheet->setCellValue('D1', 'Alamat');
        $sheet->setCellValue('E1', 'No HP');
        $sheet->setCellValue('F1', 'Akun Instagram');
        $sheet->setCellValue('G1', 'Tanggal Pendaftaran');
        $sheet->setCellValue('H1', 'Biaya Pendaftaran');
        $sheet->setCellValue('I1', 'Status');

        // Set Data
        $row = 2;
        foreach ($siswaData as $s) {
            $sheet->setCellValue('A' . $row, $s['nama']);
            $sheet->setCellValue('B' . $row, $s['tanggal_lahir']);
            $sheet->setCellValue('C' . $row, $s['nama_org_tua']);
            $sheet->setCellValue('D' . $row, $s['alamat']);
            $sheet->setCellValue('E' . $row, $s['no_hp']);
            $sheet->setCellValue('F' . $row, $s['akun_instagram']);
            $sheet->setCellValue('G' . $row, $s['tanggal_pendaftaran']);
            $sheet->setCellValue('H' . $row, $s['biaya_pendaftaran']);
            $sheet->setCellValue('I' . $row, $s['status']);
            $row++;
        }

        // Set response headers
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="data_siswa.xlsx"');
        header('Cache-Control: max-age=0');

        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
    }

    // Ekspor ke PDF
    public function exportPdf()
    {
        $nama = $this->request->getGet('nama');
        $status = $this->request->getGet('status');

        $query = $this->siswaModel;

        if ($nama) {
            $query = $query->like('nama', $nama);
        }

        if ($status) {
            $query = $query->where('status', $status);
        }

        $siswaData = $query->findAll();

        // Load Dompdf
        $dompdf = new Dompdf();
        $html = '<h2>Data Siswa</h2>';
        $html .= '<table border="1" cellpadding="10"><tr>
                    <th>Nama</th>
                    <th>Tanggal Lahir</th>
                    <th>Nama Orang Tua</th>
                    <th>Alamat</th>
                    <th>No HP</th>
                    <th>Akun Instagram</th>
                    <th>Tanggal Pendaftaran</th>
                    <th>Biaya Pendaftaran</th>
                    <th>Status</th>
                  </tr>';

        foreach ($siswaData as $s) {
            $html .= '<tr>
                        <td>' . $s['nama'] . '</td>
                        <td>' . $s['tanggal_lahir'] . '</td>
                        <td>' . $s['nama_org_tua'] . '</td>
                        <td>' . $s['alamat'] . '</td>
                        <td>' . $s['no_hp'] . '</td>
                        <td>' . $s['akun_instagram'] . '</td>
                        <td>' . $s['tanggal_pendaftaran'] . '</td>
                        <td>' . $s['biaya_pendaftaran'] . '</td>
                        <td>' . $s['status'] . '</td>
                      </tr>';
        }

        $html .= '</table>';

        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'landscape');
        $dompdf->render();

        // Output the generated PDF to Browser
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="data_siswa.pdf"');
        echo $dompdf->output();
    }
}
