<?php
// app/Models/DataKelasMuridModel.php

namespace App\Models;

use CodeIgniter\Model;

class DataKelasMuridModel extends Model
{
    protected $table = 'data_kelas_murid';
    protected $primaryKey = 'id';
    protected $allowedFields = ['id_siswa', 'id_kelas'];

    // Fungsi untuk mengambil data join dengan siswa dan kelas
    public function getDataKelasMurid()
    {
        return $this->select('data_kelas_murid.*, siswa.nama as nama_siswa, kelas.nama_kelas, kelas.keterangan')
                    ->join('siswa', 'siswa.id_siswa = data_kelas_murid.id_siswa')
                    ->join('kelas', 'kelas.id_kelas = data_kelas_murid.id_kelas')
                    ->findAll();
    }
}
