<?php

namespace App\Models;

use CodeIgniter\Model;

class SiswaModel extends Model
{
    protected $table = 'siswa';
    protected $primaryKey = 'id_siswa';
    protected $allowedFields = [
        'nama', 'tanggal_lahir', 'nama_org_tua', 'alamat', 'no_hp', 
        'akun_instagram', 'tanggal_pendaftaran', 'biaya_pendaftaran', 'status'
    ];


    
    public function getPembayaranSPPWithSiswa($start_date, $end_date)
    {
        return $this->db->table('pembayaran_spp')
                        ->select('siswa.nama, pembayaran_spp.*')
                        ->join('siswa', 'siswa.id_siswa = pembayaran_spp.id_siswa')
                        ->where("tanggal_pembayaran >=", $start_date)
                        ->where("tanggal_pembayaran <=", $end_date)
                        ->get()
                        ->getResultArray();
    }
    

}
