<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
        <?= view('layouts/sidebarsuperadmin') ?>
                <!-- Content Wrapper -->
                <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                        <h1 class="mb-4">Data Siswa</h1>
                        </div>
                    </div>
                </div>
            </div>
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
    

    <!-- Tombol tambah siswa -->

    <form method="get" action="<?= base_url('Riwayat_spp') ?>" class="form-inline mb-3">
        <label for="nama" class="mr-2">Nama:</label>
        <input type="text" name="nama" id="nama" class="form-control mr-2" value="<?= isset($_GET['nama']) ? $_GET['nama'] : '' ?>">

        <label for="status" class="mr-2">Status:</label>
        <select name="status" id="status" class="form-control mr-2">
            <option value="">Pilih Status</option>
            <option value="aktif" <?= (isset($_GET['status']) && $_GET['status'] == 'aktif') ? 'selected' : '' ?>>Aktif</option>
            <option value="nonaktif" <?= (isset($_GET['status']) && $_GET['status'] == 'nonaktif') ? 'selected' : '' ?>>Nonaktif</option>
        </select>

        <button type="submit" class="btn btn-primary">Cari</button>
    </form>

    <!-- Tabel data siswa -->
    <table class="table table-striped table-bordered">
        <thead class="thead-dark">
            <tr>
                <th>ID Siswa</th>
                <th>Nama</th>          
               
                <th>status</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($siswa)): ?>
                <?php foreach ($siswa as $row): ?>
                <tr>
                    <td><?= $row['id_siswa'] ?></td>
                    <td><?= $row['nama'] ?></td>
                    
                    <td><?= $row['status'] ?></td>
                    <td>
                        <!-- Aksi: Edit dan Delete -->
                        <a href="<?= base_url('pembayaran_spp/riwayat/' . $row['id_siswa']) ?>" class="btn btn-warning btn-sm">Detil</a>
                        
            
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="11" class="text-center">Tidak ada data siswa</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- /.content-wrapper -->                   
    </div>
     <?php else: ?>
     <div class="alert alert-danger">
     <h4>Anda tidak memiliki akses ke halaman ini.</h4>
     </div>
    <?php endif; ?>
    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
</body>
</html>
