<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
            <?= view('layouts/sidebarsuperadmin') ?>

            <!-- Content Wrapper -->
            <div class="content-wrapper">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6">
                                <h1 class="mb-4">Data Siswa</h1>
                            </div>
                        </div>
                    </div>
                </div>

                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">

<!-- Form Pencarian -->
<div class="border p-3 mb-3 rounded">
<form method="get" action="<?= base_url('siswa') ?>" class="form-inline mb-3">
        <label for="nama" class="mr-2">Nama:</label>
        <input type="text" name="nama" id="nama" class="form-control mr-2" value="<?= isset($_GET['nama']) ? $_GET['nama'] : '' ?>">

        <label for="status" class="mr-2">Status:</label>
        <select name="status" id="status" class="form-control mr-2">
            <option value="">Pilih Status</option>
            <option value="aktif" <?= (isset($_GET['status']) && $_GET['status'] == 'aktif') ? 'selected' : '' ?>>Aktif</option>
            <option value="nonaktif" <?= (isset($_GET['status']) && $_GET['status'] == 'nonaktif') ? 'selected' : '' ?>>Nonaktif</option>
        </select>

        <button type="submit" class="btn btn-primary">Cari</button>
    </form>
        </div>
    <div class="mb-3">
        <a href="<?= base_url('siswa/create') ?>" class="btn btn-success">Tambah Data Siswa</a>
        </div>
        <div class="mb-3">    
        <a href="<?= base_url('siswa/export_excel?nama=' . (isset($_GET['nama']) ? $_GET['nama'] : '') . '&status=' . (isset($_GET['status']) ? $_GET['status'] : '')) ?>" class="btn btn-info">Ekspor Excel</a>
        <a href="<?= base_url('siswa/export_pdf?nama=' . (isset($_GET['nama']) ? $_GET['nama'] : '') . '&status=' . (isset($_GET['status']) ? $_GET['status'] : '')) ?>" class="btn btn-danger">Ekspor PDF</a>
    </div>

    <?php
// Pengaturan Pagination
$items_per_page = 12; // Jumlah item yang ditampilkan per halaman
$total_items = count($siswa); // Total item
$total_pages = ceil($total_items / $items_per_page); // Total halaman

// Halaman saat ini (default adalah 1)
$current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

// Pastikan halaman saat ini dalam rentang yang valid
if ($current_page < 1) $current_page = 1;
if ($current_page > $total_pages) $current_page = $total_pages;

// Hitung indeks awal untuk halaman saat ini
$start_index = ($current_page - 1) * $items_per_page;

// Batasi data yang ditampilkan untuk halaman saat ini
$limited_siswa = array_slice($siswa, $start_index, $items_per_page);

// Ambil query string saat ini (parameter GET) kecuali 'page' untuk menjaga parameter lainnya tetap utuh
$queryString = $_SERVER['QUERY_STRING'];

// Hapus parameter 'page' yang ada dari query string
$queryString = preg_replace('/(\?|&)page=\d+/', '', $queryString);

// Tambahkan '&' jika query string ada, atau mulai dengan '?'
$queryString = ($queryString) ? '?' . $queryString . '&' : '?page=';
?>

<!-- Tabel Data Siswa -->
<div class="table-responsive border p-3">
                                    <table class="table table-striped table-bordered">
                                        <thead class="thead-dark">
        <tr>
            <th>Nama</th>
            <th>Tanggal Lahir</th>
            <th>Nama Orang Tua</th>
            <th>Alamat</th>
            <th>No HP</th>
            <th>Akun Instagram</th>
            <th>Tanggal Pendaftaran</th>
            <th>Biaya Pendaftaran</th>
            <th>Status</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($limited_siswa as $s): ?>
        <tr>
            <td><?= $s['nama'] ?></td>
            <td><?= $s['tanggal_lahir'] ?></td>
            <td><?= $s['nama_org_tua'] ?></td>
            <td><?= $s['alamat'] ?></td>
            <td><?= $s['no_hp'] ?></td>
            <td><?= $s['akun_instagram'] ?></td>
            <td><?= $s['tanggal_pendaftaran'] ?></td>
            <td><?= 'Rp ' . number_format($s['biaya_pendaftaran'], 0, ',', '.') ?></td>
            <td><?= $s['status'] ?></td>
            <td>
                <a href="<?= base_url('siswa/edit/' . $s['id_siswa']) ?>" class="btn btn-warning btn-sm">Edit</a>
                <a href="<?= base_url('siswa/delete/' . $s['id_siswa']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus data ini?')">Hapus</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<nav aria-label="Navigasi halaman">
    <ul class="pagination justify-content-center">
        <!-- Tombol Sebelumnya -->
        <li class="page-item <?= ($current_page == 1) ? 'disabled' : '' ?>">
            <a class="page-link" href="<?= $queryString ?>page=<?= $current_page - 1 ?>" aria-label="Sebelumnya">
                <span aria-hidden="true">&laquo;</span>
            </a>
        </li>

        <!-- Link Nomor Halaman -->
        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
            <li class="page-item <?= ($current_page == $i) ? 'active' : '' ?>">
                <a class="page-link" href="<?= $queryString ?>page=<?= $i ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>

        <!-- Tombol Selanjutnya -->
        <li class="page-item <?= ($current_page == $total_pages) ? 'disabled' : '' ?>">
            <a class="page-link" href="<?= $queryString ?>page=<?= $current_page + 1 ?>" aria-label="Selanjutnya">
                <span aria-hidden="true">&raquo;</span>
            </a>
        </li>
    </ul>
</nav>
        </div>

                        </div>
                    </div>
                </section>
            </div>
            <!-- /.content-wrapper -->                   
        </div>
    <?php else: ?>
        <div class="alert alert-danger">
            <h4>Anda tidak memiliki akses ke halaman ini!</h4>
        </div>
    <?php endif; ?>

  
        <!-- Bootstrap & AdminLTE JS -->
        <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
    <!-- jQuery -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
</body>
</html>
